/*
 * Copyright (c) 2008-2016 Afilias Technologies Limited. All rights reserved.
 */

package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.app.Activity;
import android.opengl.GLSurfaceView;
import android.util.Log;
import android.view.ViewGroup;

/**
 * @author Afilias Technologies Ltd
 */
class GpuLoader {

    public void load(final Activity activityContext, final DataCollector callback) {

        activityContext.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Log.d("GpuLoader", "runOnUiThread");
                final GLSurfaceView glView = new GLSurfaceView(activityContext);

                glView.setZOrderOnTop(true); // on top so is rendered correctly
                GpuRenderer renderer = new GpuRenderer(activityContext, glView, callback);

                glView.setRenderer(renderer);

                // add opengl view to current active view
                ViewGroup layout = (ViewGroup) activityContext.findViewById(android.R.id.content); // needs to be layout of current active view
                layout.addView(glView);
            }
        });
    }

}
