/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BISDetectorRSSICollector {
    private static final String TAG = "BIS_RSSI_COLLECTOR";
    private final Integer RSSI_DIFFERENCE = 10;
    private Integer mostRecentlyStoredRSSI;
    protected ConcurrentHashMap<Integer, String> values = new ConcurrentHashMap();

    BISDetectorRSSICollector() {
    }

    public void add(Integer rssi) {
        boolean isSignificantlyDifferent = false;
        if (this.mostRecentlyStoredRSSI == null || Math.abs(this.mostRecentlyStoredRSSI - rssi) >= this.RSSI_DIFFERENCE) {
            isSignificantlyDifferent = true;
        }
        if (isSignificantlyDifferent) {
            String timestamp = BigDecimal.valueOf((double)System.currentTimeMillis() / 1000.0).toString();
            this.values.put(rssi, timestamp);
            this.mostRecentlyStoredRSSI = rssi;
        }
    }

    public String toJson() {
        JSONArray jsonArray = new JSONArray();
        for (Integer rssi : this.values.keySet()) {
            String timestamp = this.values.get(rssi);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("r", (Object)rssi);
                jsonObject.put("t", (Object)timestamp);
                jsonArray.put((Object)jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonArray.toString();
    }
}

