/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import com.beaconsinspace.android.beacon.detector.BISDetectorREST;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import java.util.HashMap;
import java.util.Map;

class BISConfiguration {
    private static final String TAG = "BIS_CONFIG";
    static final String KEY_foregroundBluetoothScanPeriod = "foregroundBluetoothScanPeriod";
    static final String KEY_foregroundBluetoothBetweenScanPeriod = "foregroundBluetoothBetweenScanPeriod";
    static final String KEY_backgroundBluetoothScanPeriod = "backgroundBluetoothScanPeriod";
    static final String KEY_backgroundBluetoothBetweenScanPeriod = "backgroundBluetoothBetweenScanPeriod";
    static final String KEY_locationMonitoringInterval = "locationMonitoringInterval";

    BISConfiguration() {
    }

    static String get(String key) {
        String value = BISPersistentStorage.getString(key);
        if (value == null) {
            value = BISConfiguration.getDefault(key);
        }
        return value;
    }

    static void set(String key, String value) {
        BISPersistentStorage.storeString(key, value);
    }

    private static String getDefault(String key) {
        String value = null;
        switch (key) {
            case "foregroundBluetoothScanPeriod": {
                value = "1100";
                break;
            }
            case "foregroundBluetoothBetweenScanPeriod": {
                value = "0";
                break;
            }
            case "backgroundBluetoothScanPeriod": {
                value = "10000";
                break;
            }
            case "backgroundBluetoothBetweenScanPeriod": {
                value = "60000";
                break;
            }
            case "locationMonitoringInterval": {
                value = "5340000";
            }
        }
        return value;
    }

    static boolean update() {
        HashMap<String, String> data = BISDetectorREST.getInitializationData();
        if (data == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            BISConfiguration.set(key, value);
        }
        return true;
    }
}

