/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.util.Log;
import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BISDetectorRSSICollector {
    private static final String TAG = "BIS_RSSI_COLLECTOR";
    private final Integer RSSI_DIFFERENCE = 10;
    private Integer mostRecentlyStoredRSSI;
    protected ConcurrentHashMap<Integer, String> values = new ConcurrentHashMap();

    public void add(Integer rssi) {
        Log.d((String)TAG, (String)("RSSI: " + rssi.toString()));
        boolean isSignificantlyDifferent = false;
        if (this.mostRecentlyStoredRSSI == null || Math.abs(this.mostRecentlyStoredRSSI - rssi) >= this.RSSI_DIFFERENCE) {
            isSignificantlyDifferent = true;
        }
        if (isSignificantlyDifferent) {
            String timestamp = BigDecimal.valueOf((double)System.currentTimeMillis() / 1000.0).toString();
            Log.d((String)TAG, (String)("TIME: " + timestamp));
            this.values.put(rssi, timestamp);
            this.mostRecentlyStoredRSSI = rssi;
        }
        Log.d((String)TAG, (String)("CURRENT RSSIs: " + this.values.toString()));
    }

    public String toJson() {
        JSONArray jsonArray = new JSONArray();
        for (Integer rssi : this.values.keySet()) {
            String timestamp = this.values.get(rssi);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("r", (Object)rssi);
                jsonObject.put("t", (Object)timestamp);
                jsonArray.put((Object)jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonArray.toString();
    }
}

