/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetectorInternalDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorREST;
import com.beaconsinspace.android.beacon.detector.BISLocationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.json.JSONException;
import org.json.JSONObject;

class BISDetectorManager
implements BeaconConsumer {
    private static final String TAG = "BIS_BEACONS_MANAGER";
    private static final Long BEACON_EXIT_THRESHOLD = 30000L;
    static BISDetectorInternalDelegate delegate;
    Context context = null;
    BeaconManager beaconManager = null;
    private static final ArrayList<Region> beaconsBeeingRanged;
    private static final ConcurrentHashMap<String, Long> beaconsInRangeMap;
    private static final ConcurrentHashMap<String, ArrayList<Beacon>> beaconsInRangeByUUID;
    public ArrayList<String> uuids = new ArrayList();

    BISDetectorManager() {
    }

    public static void setDelegate(BISDetectorInternalDelegate _delegate) {
        delegate = _delegate;
    }

    public boolean setContextAndInit(Context ctx) {
        if (ctx == null) {
            Log.e((String)TAG, (String)"Context is null");
            return false;
        }
        this.context = ctx;
        if (this.beaconManager == null) {
            this.beaconManager = BeaconManager.getInstanceForApplication((Context)this.context);
            this.setScanPeriods(null, null, null, 60000L);
            String iBeaconLayout = "m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(iBeaconLayout));
            String altBeaconLayout = "m:2-3=beac,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(altBeaconLayout));
            this.doBind();
        }
        return true;
    }

    public void setScanPeriods(Long foregroundScanPeriod, Long foregroundBetweenScanPeriod, Long backgroundScanPeriod, Long backgroundBetweenScanPeriod) {
        if (this.beaconManager == null) {
            Log.i((String)TAG, (String)"Beacon Manager not initialized, not setting scan periods.");
            return;
        }
        if (foregroundScanPeriod != null) {
            this.beaconManager.setForegroundScanPeriod(foregroundScanPeriod.longValue());
        }
        if (foregroundBetweenScanPeriod != null) {
            this.beaconManager.setForegroundBetweenScanPeriod(foregroundBetweenScanPeriod.longValue());
        }
        if (backgroundScanPeriod != null) {
            this.beaconManager.setBackgroundScanPeriod(backgroundScanPeriod.longValue());
        }
        if (backgroundBetweenScanPeriod != null) {
            this.beaconManager.setBackgroundBetweenScanPeriod(backgroundBetweenScanPeriod.longValue());
        }
        try {
            if (this.beaconManager.isBound((BeaconConsumer)this)) {
                this.beaconManager.updateScanPeriods();
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Error updating scan periods: " + e.getMessage()));
        }
    }

    public void updateUUIDs(ArrayList<String> _uuids) {
        this.uuids = new ArrayList<String>(_uuids);
    }

    public void startRanging() {
        this.stopRanging();
        this.doBind();
    }

    public void stopRanging() {
        try {
            for (Region region : beaconsBeeingRanged) {
                this.beaconManager.stopRangingBeaconsInRegion(region);
            }
            this.undoBind();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("RemoteException: " + e.toString()));
        }
    }

    public void doBind() {
        if (this.beaconManager != null && !this.beaconManager.isBound((BeaconConsumer)this)) {
            this.beaconManager.bind((BeaconConsumer)this);
        }
    }

    public void undoBind() {
        if (this.beaconManager != null && this.beaconManager.isBound((BeaconConsumer)this)) {
            this.beaconManager.unbind((BeaconConsumer)this);
        }
    }

    public void onBeaconServiceConnect() {
        this.beaconManager.setRangeNotifier(new RangeNotifier(){

            public void didRangeBeaconsInRegion(Collection<Beacon> collection, Region region) {
                String uuidRegion = region.getId1().toString();
                ArrayList<Beacon> beaconsInRange = (ArrayList<Beacon>)beaconsInRangeByUUID.get(uuidRegion);
                if (beaconsInRange == null) {
                    beaconsInRange = new ArrayList<Beacon>();
                    beaconsInRangeByUUID.put(uuidRegion, beaconsInRange);
                }
                ArrayList _beaconsInRange = new ArrayList(beaconsInRange);
                ArrayList<Beacon> _collection = new ArrayList<Beacon>(collection);
                for (Beacon beaconInRange : _beaconsInRange) {
                    String uidBeaconInRange = BISDetectorManager.uniqueIdentifierForBeacon(beaconInRange);
                    boolean isFound = false;
                    Beacon foundBeacon = null;
                    for (Beacon beaconInCollection : _collection) {
                        String uidBeaconInCollection = BISDetectorManager.uniqueIdentifierForBeacon(beaconInCollection);
                        if (!uidBeaconInRange.equalsIgnoreCase(uidBeaconInCollection)) continue;
                        isFound = true;
                        foundBeacon = beaconInRange;
                        break;
                    }
                    if (isFound && foundBeacon != null) {
                        Log.d((String)BISDetectorManager.TAG, (String)("beaconInRange :: " + uidBeaconInRange));
                        beaconsInRangeMap.put(uidBeaconInRange, System.currentTimeMillis());
                        continue;
                    }
                    Long timeout = (Long)beaconsInRangeMap.get(uidBeaconInRange);
                    Long diff = timeout > 0L ? System.currentTimeMillis() - timeout : 0L;
                    Log.d((String)BISDetectorManager.TAG, (String)("beaconOutOfRange: " + uidBeaconInRange + " ::: " + diff));
                    if (diff < BEACON_EXIT_THRESHOLD) continue;
                    beaconsInRange.remove(beaconInRange);
                    beaconsInRangeMap.remove(uidBeaconInRange);
                    BISDetectorManager.this.handleBeaconExit(beaconInRange);
                }
                for (Beacon beaconInCollection : _collection) {
                    String uidBeaconInCollection = BISDetectorManager.uniqueIdentifierForBeacon(beaconInCollection);
                    boolean isKnown = false;
                    for (Beacon beaconInRange : _beaconsInRange) {
                        String uidBeaconInRange = BISDetectorManager.uniqueIdentifierForBeacon(beaconInRange);
                        if (!uidBeaconInCollection.equalsIgnoreCase(uidBeaconInRange)) continue;
                        isKnown = true;
                        break;
                    }
                    if (isKnown) continue;
                    beaconsInRange.add(beaconInCollection);
                    _beaconsInRange = new ArrayList(beaconsInRange);
                    beaconsInRangeMap.put(uidBeaconInCollection, System.currentTimeMillis());
                    BISDetectorManager.this.handleBeaconEnter(beaconInCollection);
                }
            }
        });
        this.beaconManager.setMonitorNotifier(new MonitorNotifier(){

            public void didEnterRegion(Region region) {
            }

            public void didExitRegion(Region region) {
            }

            public void didDetermineStateForRegion(int state, Region region) {
            }
        });
        if (this.uuids.size() > 0) {
            beaconsBeeingRanged.clear();
            try {
                for (int n = 0; n < this.uuids.size(); ++n) {
                    String uuid = this.uuids.get(n);
                    Region region = new Region("BISDetector" + n, Identifier.parse((String)uuid.toLowerCase()), null, null);
                    beaconsBeeingRanged.add(region);
                    this.beaconManager.startRangingBeaconsInRegion(region);
                }
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)("RemoteException: " + e.toString()));
            }
        }
    }

    private void handleBeaconEnter(Beacon b) {
        final Beacon beacon = b;
        Thread thread = new Thread(){

            @Override
            public void run() {
                String jsonDataString = BISDetectorREST.notifyAboutBeaconEnter(beacon);
                String beaconId = null;
                try {
                    JSONObject jsonDataObject = new JSONObject(jsonDataString);
                    int code = jsonDataObject.getInt("code");
                    if (code != 200) {
                        Log.e((String)BISDetectorManager.TAG, (String)("Unsuccessful API Response occurred" + jsonDataString));
                        return;
                    }
                    beaconId = jsonDataObject.getJSONObject("data").getString("beaconId");
                }
                catch (JSONException e) {
                    Log.e((String)BISDetectorManager.TAG, (String)("Failed to parse JSON" + e.getMessage()));
                }
                if (delegate != null && beaconId != null) {
                    BISLocationListener.assignLocationToBeaconId(BISDetectorManager.uniqueIdentifierForBeacon(beacon));
                    delegate.onBeaconEnter(beaconId);
                }
            }
        };
        thread.start();
    }

    private void handleBeaconExit(Beacon b) {
        final Beacon beacon = b;
        Thread thread = new Thread(){

            @Override
            public void run() {
                String jsonDataString = BISDetectorREST.notifyAboutBeaconExit(beacon);
                String beaconId = null;
                try {
                    JSONObject jsonDataObject = new JSONObject(jsonDataString);
                    int code = jsonDataObject.getInt("code");
                    if (code != 200) {
                        Log.e((String)BISDetectorManager.TAG, (String)("Unsuccessful API Response occurred" + jsonDataString));
                        return;
                    }
                    beaconId = jsonDataObject.getJSONObject("data").getString("beaconId");
                }
                catch (JSONException e) {
                    Log.e((String)BISDetectorManager.TAG, (String)("Failed to parse JSON" + e.getMessage()));
                }
                if (delegate != null && beaconId != null) {
                    delegate.onBeaconExit(beaconId);
                }
            }
        };
        thread.start();
    }

    public static String[] idsForBeacon(Beacon beacon) {
        if (beacon == null) {
            return new String[]{"", "", ""};
        }
        Identifier id1 = beacon.getIdentifiers().size() > 0 ? beacon.getId1() : null;
        Identifier id2 = beacon.getIdentifiers().size() > 1 ? beacon.getId2() : null;
        Identifier id3 = beacon.getIdentifiers().size() > 2 ? beacon.getId3() : null;
        String uuid = id1 != null ? id1.toString() : "";
        String major = id2 != null ? id2.toString() : "";
        String minor = id3 != null ? id3.toString() : "";
        return new String[]{uuid, major, minor};
    }

    public static String uniqueIdentifierForBeacon(Beacon beacon) {
        if (beacon == null) {
            return "";
        }
        String[] strings = BISDetectorManager.idsForBeacon(beacon);
        String uuid = strings[0];
        String major = strings[1];
        String minor = strings[2];
        if (uuid.contains("0x")) {
            uuid = uuid.replace("0x", "");
        }
        if (major.contains("0x")) {
            major = uuid.replace("0x", "");
        }
        if (minor.contains("0x")) {
            minor = uuid.replace("0x", "");
        }
        String uniqueId = uuid + "_" + major + "_" + minor;
        return uuid + ":" + uniqueId.hashCode();
    }

    public Context getApplicationContext() {
        return this.context;
    }

    public void unbindService(ServiceConnection serviceConnection) {
        this.context.unbindService(serviceConnection);
    }

    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return this.context.bindService(intent, serviceConnection, i);
    }

    static {
        beaconsBeeingRanged = new ArrayList();
        beaconsInRangeMap = new ConcurrentHashMap();
        beaconsInRangeByUUID = new ConcurrentHashMap();
    }
}

