/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import java.util.HashMap;
import java.util.Map;

class BISLocationListener
extends AsyncTask<String, String, Location>
implements LocationListener {
    private static final String TAG = "BIS_LOCATION_LISTENER";
    private static final int TWO_MINUTES = 120000;
    private static final int LOCATION_HALF_LIFE = 30000;
    private static final HashMap<String, Location> beaconLocations = new HashMap();
    static Location currentBestLocation;
    static boolean isCurrentlyMonitoring;
    private Context context;
    private Location foundLocation;
    private LocationManager locationManager;

    BISLocationListener(Context ctx) {
        this.context = ctx;
    }

    public static void assignLocationToBeaconId(String beaconId) {
        if (BISLocationListener.locationIsStillValid(currentBestLocation)) {
            BISLocationListener.setBeaconIdLocation(beaconId, currentBestLocation);
        } else {
            BISLocationListener.setBeaconIdLocation(beaconId, null);
            if (!isCurrentlyMonitoring) {
                BISLocationListener locationListener = new BISLocationListener(BISDetector.context);
                locationListener.execute(new String[]{beaconId});
            }
        }
    }

    public static Location getLocationByBeaconId(String beaconId) {
        Location loc = beaconLocations.get(beaconId);
        beaconLocations.remove(beaconId);
        return loc;
    }

    private static void setBeaconIdLocation(String beaconId, Location location) {
        beaconLocations.put(beaconId, location);
    }

    protected Location doInBackground(String ... beaconIdArr) {
        this.beginLocationMonitoring();
        while (this.foundLocation == null) {
        }
        return this.foundLocation;
    }

    protected void onPostExecute(Location location) {
        for (Map.Entry<String, Location> entry : beaconLocations.entrySet()) {
            String entryBeaconId = entry.getKey();
            Location entryLocation = entry.getValue();
            if (entryLocation != null) continue;
            BISLocationListener.setBeaconIdLocation(entryBeaconId, location);
        }
        super.onPostExecute((Object)location);
    }

    static boolean locationIsStillValid(Location loc) {
        if (loc == null) {
            return false;
        }
        long locTime = loc.getTime();
        long currentTime = System.currentTimeMillis();
        return currentTime - locTime < 30000L;
    }

    void beginLocationMonitoring() {
        try {
            this.locationManager = (LocationManager)this.context.getSystemService("location");
            boolean gps_enabled = false;
            boolean network_enabled = false;
            try {
                gps_enabled = this.locationManager.isProviderEnabled("gps");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                network_enabled = this.locationManager.isProviderEnabled("network");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!gps_enabled && !network_enabled) {
                this.endLocationMonitoring();
                return;
            }
            if (gps_enabled) {
                this.locationManager.requestLocationUpdates("gps", 5000L, 10.0f, (LocationListener)this, Looper.getMainLooper());
            }
            if (network_enabled) {
                this.locationManager.requestLocationUpdates("network", 5000L, 10.0f, (LocationListener)this, Looper.getMainLooper());
            }
            isCurrentlyMonitoring = true;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("LOCATION EXCEPTION" + e.getMessage()));
            this.endLocationMonitoring();
        }
    }

    void endLocationMonitoring() {
        try {
            this.locationManager.removeUpdates((LocationListener)this);
            isCurrentlyMonitoring = false;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("FAILED TO END LOCATION MONITORING" + e.getMessage()));
        }
    }

    public void onLocationChanged(Location loc) {
        this.makeUseOfNewLocation(loc);
    }

    void makeUseOfNewLocation(Location location) {
        if (this.isBetterLocation(location, currentBestLocation)) {
            this.endLocationMonitoring();
            currentBestLocation = location;
            this.foundLocation = location;
        }
    }

    protected boolean isBetterLocation(Location location, Location currentBestLocation) {
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 120000L;
        boolean isSignificantlyOlder = timeDelta < -120000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = this.isSameProvider(location.getProvider(), currentBestLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    private boolean isSameProvider(String provider1, String provider2) {
        if (provider1 == null) {
            return provider2 == null;
        }
        return provider1.equals(provider2);
    }

    public void onStatusChanged(String var1, int var2, Bundle var3) {
        Log.i((String)TAG, (String)"STATUS CHANGED");
    }

    public void onProviderEnabled(String var1) {
        this.beginLocationMonitoring();
    }

    public void onProviderDisabled(String var1) {
        this.endLocationMonitoring();
    }

    static {
        isCurrentlyMonitoring = false;
    }
}

