/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetectorDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorInternalDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorManager;
import com.beaconsinspace.android.beacon.detector.BISDetectorREST;
import com.beaconsinspace.android.beacon.detector.BISDetectorServicesListener;
import com.beaconsinspace.android.beacon.detector.BISDeviceUUIDFactory;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;
import java.util.UUID;

public class BISDetector
implements BISDetectorInternalDelegate {
    public static String SDK_VERSION = "1.1.2";
    private static final String TAG = "BIS_API";
    static String API_KEY = "";
    static String ADID = "";
    static UUID UUID;
    static BISDetector sharedInstance;
    static Context context;
    static BISDetectorManager beaconsManager;
    static BISDetectorDelegate delegate;

    public static void configure(String key, Context ctx, BISDetectorDelegate dlgt) {
        Log.d((String)TAG, (String)("Configuring BISDetector SDK " + SDK_VERSION));
        delegate = dlgt;
        API_KEY = key != null ? key : "";
        context = ctx;
        beaconsManager.setContextAndInit(ctx);
        BISDetector internalDelegate = sharedInstance;
        BISDetectorREST.setDelegate(internalDelegate);
        BISDetectorServicesListener.setDelegate(internalDelegate);
        BISDetectorManager.setDelegate(internalDelegate);
        BISDeviceUUIDFactory UUIDFactory = new BISDeviceUUIDFactory(context);
        UUID = UUIDFactory.getDeviceUuid();
        BISDetector.getUserADID();
    }

    static void performInitialSetup() {
        String errorMessage = "";
        if (!BISDetector.isLocationServiceEnabled()) {
            errorMessage = "Location Services are not enabled. Please enable them in Settings.";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        if (!BISDetector.isInternetAvailable()) {
            errorMessage = "Network Services are not enabled. Please enable them in Settings.";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        if (!BISDetector.isBluetoothEnabled()) {
            errorMessage = "Bluetooth is not enabled. Please turn it on to proceed";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        BISDetectorREST.getBeaconsInfoFromServer();
    }

    static BISDetectorManager beaconsManager() {
        return beaconsManager;
    }

    static void getUserADID() {
        if (context == null) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    AdvertisingIdClient.Info adInfo;
                    block6: {
                        adInfo = null;
                        try {
                            adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                            if (adInfo != null) break block6;
                        }
                        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException e) {
                            block7: {
                                try {
                                    Log.e((String)BISDetector.TAG, (String)("getAdvertisingIdInfo exception: " + e.toString()));
                                    if (adInfo != null) break block7;
                                }
                                catch (Throwable throwable) {
                                    if (adInfo == null) {
                                        BISDetector.onUserADIDReceiveFail();
                                    } else {
                                        ADID = adInfo.getId();
                                        boolean success = ADID != null && ADID.length() > 0;
                                        Handler handler = new Handler(Looper.getMainLooper());
                                        handler.post(new Runnable(success){
                                            final /* synthetic */ boolean val$success;
                                            {
                                                this.val$success = bl;
                                            }

                                            @Override
                                            public void run() {
                                                if (this.val$success) {
                                                    BISDetector.onUserADIDReceiveSuccess();
                                                } else {
                                                    BISDetector.onUserADIDReceiveFail();
                                                }
                                            }
                                        });
                                    }
                                    throw throwable;
                                }
                                BISDetector.onUserADIDReceiveFail();
                            }
                            ADID = adInfo.getId();
                            boolean success = ADID != null && ADID.length() > 0;
                            Handler handler = new Handler(Looper.getMainLooper());
                            handler.post(new /* invalid duplicate definition of identical inner class */);
                        }
                        BISDetector.onUserADIDReceiveFail();
                        break block8;
                    }
                    ADID = adInfo.getId();
                    boolean success = ADID != null && ADID.length() > 0;
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new /* invalid duplicate definition of identical inner class */);
                }
            }
        };
        thread.start();
    }

    public static boolean isLocationServiceEnabled() {
        if (context == null) {
            return false;
        }
        int locationMode = 0;
        try {
            locationMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return locationMode != 0;
    }

    public static boolean isInternetAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static boolean isBluetoothEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        return adapter.isEnabled();
    }

    public static void startRanging() {
        beaconsManager.setContextAndInit(context);
        beaconsManager.startRanging();
    }

    public static void stopRanging() {
        beaconsManager.stopRanging();
    }

    static void onUserADIDReceiveSuccess() {
        BISDetector.performInitialSetup();
    }

    static void onUserADIDReceiveFail() {
        BISDetector.performInitialSetup();
    }

    @Override
    public void onBeaconsInfoReceiveSuccess() {
        Log.d((String)TAG, (String)"BLE ranging has begun");
        BISDetector.startRanging();
    }

    @Override
    public void onBeaconsInfoReceiveFail(int errorCode, String errorMessage) {
        if (errorMessage == null) {
            switch (errorCode) {
                case 401: {
                    errorMessage = "Invalid Authentication";
                    break;
                }
                default: {
                    errorMessage = "An error occurred";
                }
            }
        }
        errorMessage = errorCode + " : " + errorMessage;
        Log.e((String)TAG, (String)errorMessage);
        if (delegate != null) {
            delegate.onBISError(503, errorMessage);
        }
    }

    @Override
    public void checkIfShouldUpdateBeaconsInfo() {
        if (BISDetector.isInternetAvailable() && BISDetector.beaconsManager.uuids.size() == 0) {
            BISDetectorREST.getBeaconsInfoFromServer();
        }
    }

    @Override
    public void onBeaconEnter(String beaconId) {
        if (delegate != null) {
            delegate.didEnterBISRegion(beaconId);
        }
    }

    @Override
    public void onBeaconExit(String beaconId) {
        if (delegate != null) {
            delegate.didExitBISRegion(beaconId);
        }
    }

    static {
        sharedInstance = new BISDetector();
        beaconsManager = new BISDetectorManager();
    }
}

