/*
 * Decompiled with CFR 0.152.
 */
package com.bcgdv.asia.lib.fanmenu;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import com.bcgdv.asia.lib.fanmenu.R;

public class FanMenuButtons
extends AppCompatTextView {
    protected long mAnimationDuration = 200L;
    protected float mAngleBetweenButtons = 10.0f;
    protected String[] menus = null;
    protected int[] colors = null;
    protected Paint mPaint = new Paint(1);
    protected Paint mTxtPaint = new Paint(1);
    protected Drawable[] drawables = null;
    protected RectF[] mButtons = null;
    protected Bitmap[] mBitmap = null;
    protected Canvas[] mCanvas = null;
    protected Matrix[] mMatrix = null;
    protected Rect[] mTextBounds = null;
    protected float mButtonHeight = 32.0f;
    protected float mButtonWidth = 32.0f;
    protected float mRotateAngle = this.mAngleBetweenButtons;
    protected float mAdditionalRotateAngle = 0.0f;
    protected float mMinBounceBackAngle = -1000.0f;
    protected float mMaxBounceBackAngle = 1000.0f;
    protected float mDrawablePadding = 8.0f;
    protected float mButtonLeftStart = 0.0f;
    protected OnFanClickListener mClickListener;
    protected OnFanAnimationListener mAnimListener;
    private int mViewScaledTouchSlop = 0;
    private boolean mAnimatingIn = false;
    private boolean mAnimationInProgress = false;
    private boolean mEnableTouchMovement = true;
    private boolean mRememberMovedPosition = false;
    private float dp2 = 2.0f;
    private float dp1 = 1.0f;
    private long mDownTime = 0L;
    private RectF mTouchArea = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private boolean mPointerDown = false;
    private boolean mIsMoving = false;

    public FanMenuButtons(Context context) {
        super(context);
        this.init(context, null);
    }

    public FanMenuButtons(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FanMenuButtons(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(Context context, AttributeSet attrs) {
        float multi = this.getResources().getDisplayMetrics().density;
        this.dp2 *= multi;
        this.dp1 *= multi;
        this.mPaint.setAntiAlias(true);
        this.mTxtPaint = new Paint((Paint)this.getPaint());
        this.mTxtPaint.setColor(this.getTextColors().getDefaultColor());
        this.mTxtPaint.setAntiAlias(true);
        this.mButtonHeight = multi * this.mButtonHeight;
        this.mDrawablePadding = multi * this.mDrawablePadding;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FanMenuButtons, 0, 0);
        try {
            int i;
            int leftDrawablesArrayResId;
            int colorsArrayResId;
            block18: {
                TypedValue outValue = new TypedValue();
                ta.getValue(R.styleable.FanMenuButtons_fanButtonColors, outValue);
                colorsArrayResId = outValue.resourceId;
                outValue = new TypedValue();
                ta.getValue(R.styleable.FanMenuButtons_fanLeftDrawable, outValue);
                leftDrawablesArrayResId = outValue.resourceId;
                outValue = new TypedValue();
                ta.getValue(R.styleable.FanMenuButtons_fanMenuLabels, outValue);
                int menuLabelsArrayResId = outValue.resourceId;
                try {
                    this.menus = context.getResources().getStringArray(menuLabelsArrayResId);
                }
                catch (Resources.NotFoundException nfe) {
                    if (!this.isInEditMode()) break block18;
                    this.menus = new String[]{"Submenu 1", "Submenu 2", "Submenu 3", "Submenu 4"};
                }
            }
            try {
                this.colors = new int[this.menus.length];
                if (this.isInEditMode()) {
                    int[] tempColors = new int[]{17170455, 17170451, 17170453, 17170457};
                    for (i = 0; i < this.menus.length; ++i) {
                        this.colors[i] = ContextCompat.getColor((Context)context, (int)tempColors[i % tempColors.length]);
                    }
                } else {
                    TypedArray colorType = context.getResources().obtainTypedArray(colorsArrayResId);
                    for (i = 0; i < this.colors.length; ++i) {
                        this.colors[i] = colorType.getColor(i, this.colors[i]);
                    }
                    colorType.recycle();
                }
            }
            catch (Resources.NotFoundException colorType) {
                // empty catch block
            }
            try {
                this.drawables = new Drawable[this.menus.length];
                if (this.isInEditMode()) {
                    for (int i2 = 0; i2 < this.drawables.length; ++i2) {
                        this.drawables[i2] = ContextCompat.getDrawable((Context)context, (int)17301574);
                    }
                } else {
                    TypedArray icons = context.getResources().obtainTypedArray(leftDrawablesArrayResId);
                    for (i = 0; i < this.drawables.length; ++i) {
                        this.drawables[i] = icons.getDrawable(i);
                    }
                    icons.recycle();
                }
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
            this.mAnimationDuration = ta.getInt(R.styleable.FanMenuButtons_fanAnimationDuration, (int)this.mAnimationDuration);
            this.mAngleBetweenButtons = ta.getInt(R.styleable.FanMenuButtons_fanAngleBetweenButtons, (int)this.mAngleBetweenButtons);
            this.mDrawablePadding = ta.getDimension(R.styleable.FanMenuButtons_fanLeftDrawablePadding, this.mDrawablePadding);
            this.mButtonHeight = ta.getDimension(R.styleable.FanMenuButtons_fanButtonHeight, this.mButtonHeight);
            this.mEnableTouchMovement = ta.getBoolean(R.styleable.FanMenuButtons_fanEnableTouchMovement, this.mEnableTouchMovement);
            this.mRememberMovedPosition = ta.getBoolean(R.styleable.FanMenuButtons_fanRememberMovedPosition, this.mRememberMovedPosition);
            this.mMinBounceBackAngle = ta.getInt(R.styleable.FanMenuButtons_fanMinBounceBackAngle, (int)this.mMinBounceBackAngle);
            this.mMaxBounceBackAngle = ta.getInt(R.styleable.FanMenuButtons_fanMaxBounceBackAngle, (int)this.mMaxBounceBackAngle);
        }
        finally {
            ta.recycle();
        }
        this.mButtons = new RectF[this.menus.length];
        this.mBitmap = new Bitmap[this.menus.length];
        this.mCanvas = new Canvas[this.menus.length];
        this.mMatrix = new Matrix[this.menus.length];
        this.mTextBounds = new Rect[this.menus.length];
        if (!this.isInEditMode() && this.getVisibility() == 8) {
            this.setVisibility(4);
        }
        ViewConfiguration viewConfig = ViewConfiguration.get((Context)context);
        this.mViewScaledTouchSlop = viewConfig.getScaledTouchSlop();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minw = this.getPaddingLeft() + this.getPaddingRight() + this.getSuggestedMinimumWidth();
        int w = FanMenuButtons.resolveSizeAndState((int)minw, (int)widthMeasureSpec, (int)1);
        int minh = this.getPaddingBottom() + this.getPaddingTop() + this.getSuggestedMinimumHeight();
        int h = FanMenuButtons.resolveSizeAndState((int)minh, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(w, h);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initIfNeeded(w, h);
    }

    protected void initIfNeeded(int w, int h) {
        if (this.mCanvas[0] == null) {
            this.mButtonLeftStart = this.getPaddingLeft();
            this.mButtonWidth = w - this.getPaddingLeft() - this.getPaddingRight();
            for (int i = 0; i < this.mButtons.length; ++i) {
                this.mBitmap[i] = Bitmap.createBitmap((int)((int)this.mButtonWidth), (int)((int)(this.mButtonHeight + this.dp2)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mButtons[i] = new RectF(this.mButtonLeftStart, this.dp1, this.mButtonWidth, this.mButtonHeight);
                this.mCanvas[i] = new Canvas(this.mBitmap[i]);
                this.setupMatrix(i);
                this.mTextBounds[i] = new Rect();
                this.getPaint().getTextBounds(this.menus[i], 0, this.menus[i].length(), this.mTextBounds[i]);
                this.mCanvas[i].drawColor(0);
                this.drawBitmap(i);
            }
        }
    }

    protected void setupMatrixs() {
        for (int i = 0; i < this.mButtons.length; ++i) {
            this.setupMatrix(i);
        }
    }

    protected void setupMatrix(int i) {
        if (this.mMatrix[i] == null) {
            this.mMatrix[i] = new Matrix();
        }
        this.mMatrix[i].setRotate((float)i * this.mRotateAngle + this.mAdditionalRotateAngle, (float)this.mBitmap[i].getWidth() - this.mButtonHeight / 2.0f, (float)(this.mBitmap[i].getHeight() / 2));
        this.mMatrix[i].postTranslate(0.0f, (float)this.getHeight() - this.mButtonHeight - (float)this.getPaddingBottom());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mAnimatingIn && this.mButtons[this.menus.length - 1].left != this.mButtonLeftStart) {
            int index = this.menus.length - 1;
            this.drawBitmap(index);
            canvas.drawBitmap(this.mBitmap[index], this.mMatrix[index], null);
            return;
        }
        for (int i = 0; i < this.mButtons.length; ++i) {
            canvas.drawBitmap(this.mBitmap[i], this.mMatrix[i], null);
        }
    }

    protected void drawAllBitmaps() {
        for (int i = 0; i < this.mButtons.length; ++i) {
            this.drawBitmap(i);
        }
    }

    protected void drawBitmap(int i) {
        this.mCanvas[i].drawColor(0, PorterDuff.Mode.CLEAR);
        this.mPaint.setColor(this.colors[i]);
        this.mPaint.setAntiAlias(true);
        this.mCanvas[i].drawRoundRect(this.mButtons[i], this.mButtonHeight / 2.0f, this.mButtonHeight / 2.0f, this.mPaint);
        if (this.drawables[i] != null) {
            this.mCanvas[i].drawText(this.menus[i], this.mButtons[i].left + this.mButtonHeight + this.mDrawablePadding, this.mButtons[i].centerY() + (float)(this.mTextBounds[i].height() / 2) - this.dp2, this.mTxtPaint);
            this.drawables[i].setBounds((int)(this.mButtons[i].left + this.dp1), (int)(this.mButtons[i].top + this.dp1), (int)(this.mButtons[i].left - this.dp1 + this.mButtonHeight), (int)(this.mButtons[i].bottom - this.dp1));
            this.drawables[i].draw(this.mCanvas[i]);
        } else {
            this.mCanvas[i].drawText(this.menus[i], this.mButtons[i].left + this.mDrawablePadding, this.mButtons[i].centerY() + (float)(this.mTextBounds[i].height() / 2) - this.dp2, this.mTxtPaint);
        }
    }

    public void toggleShow() {
        if (this.getVisibility() == 0) {
            this.animateOut();
        } else {
            this.animateIn();
        }
    }

    public void animateIn() {
        if (this.mAnimationInProgress) {
            return;
        }
        if (this.getBackground() != null) {
            this.getBackground().setAlpha(0);
        }
        this.mAnimationInProgress = true;
        this.initIfNeeded(this.getWidth(), this.getHeight());
        ValueAnimator grow = ValueAnimator.ofInt((int[])new int[]{(int)this.mButtonWidth, (int)this.mButtonLeftStart});
        grow.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        grow.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int w = (Integer)animation.getAnimatedValue();
                for (int i = 0; i < FanMenuButtons.this.mButtons.length; ++i) {
                    FanMenuButtons.this.mButtons[i].left = w;
                }
                FanMenuButtons.this.invalidate();
            }
        });
        ValueAnimator alpha = ValueAnimator.ofInt((int[])new int[]{0, 255});
        alpha.setDuration(this.mAnimationDuration);
        alpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int a = (Integer)animation.getAnimatedValue();
                if (FanMenuButtons.this.getBackground() != null) {
                    FanMenuButtons.this.getBackground().setAlpha(a);
                }
            }
        });
        ValueAnimator rotate = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.mAngleBetweenButtons});
        rotate.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        rotate.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float r;
                if (FanMenuButtons.this.mAnimatingIn) {
                    FanMenuButtons.this.drawBitmap(FanMenuButtons.this.menus.length - 1);
                }
                FanMenuButtons.this.mAnimatingIn = false;
                FanMenuButtons.this.mRotateAngle = r = ((Float)animation.getAnimatedValue()).floatValue();
                FanMenuButtons.this.setupMatrixs();
                FanMenuButtons.this.invalidate();
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                FanMenuButtons.this.mAnimatingIn = true;
                FanMenuButtons.this.mRotateAngle = 0.0f;
                FanMenuButtons.this.setupMatrixs();
                FanMenuButtons.this.setVisibility(0);
                if (FanMenuButtons.this.mAnimListener != null) {
                    FanMenuButtons.this.mAnimListener.onAnimateInStarted();
                }
            }

            public void onAnimationEnd(Animator animation) {
                FanMenuButtons.this.mAnimatingIn = false;
                for (int i = 0; i < FanMenuButtons.this.mButtons.length; ++i) {
                    FanMenuButtons.this.mButtons[i].left = FanMenuButtons.this.mButtonLeftStart;
                }
                FanMenuButtons.this.mRotateAngle = FanMenuButtons.this.mAngleBetweenButtons;
                FanMenuButtons.this.setupMatrixs();
                FanMenuButtons.this.mAnimationInProgress = false;
                FanMenuButtons.this.invalidate();
                if (FanMenuButtons.this.mAnimListener != null) {
                    FanMenuButtons.this.mAnimListener.onAnimateInFinished();
                }
            }

            public void onAnimationCancel(Animator animation) {
                this.onAnimationEnd(animation);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        set.setDuration(this.mAnimationDuration);
        set.playSequentially(new Animator[]{grow, rotate});
        set.start();
        if (this.getBackground() != null) {
            alpha.start();
        }
    }

    public void animateOut() {
        if (this.mAnimationInProgress) {
            return;
        }
        this.mAnimationInProgress = true;
        ValueAnimator grow = ValueAnimator.ofInt((int[])new int[]{(int)this.mButtonLeftStart, (int)this.mButtonWidth});
        grow.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        grow.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FanMenuButtons.this.mAnimatingIn = true;
                int w = (Integer)animation.getAnimatedValue();
                for (int i = 0; i < FanMenuButtons.this.mButtons.length; ++i) {
                    FanMenuButtons.this.mButtons[i].left = w;
                }
                FanMenuButtons.this.invalidate();
            }
        });
        ValueAnimator alpha = ValueAnimator.ofInt((int[])new int[]{255, 0});
        alpha.setDuration(this.mAnimationDuration);
        alpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int a = (Integer)animation.getAnimatedValue();
                if (FanMenuButtons.this.getBackground() != null) {
                    FanMenuButtons.this.getBackground().setAlpha(a);
                }
            }
        });
        ValueAnimator rotate = ValueAnimator.ofFloat((float[])new float[]{this.mAngleBetweenButtons, 0.0f});
        rotate.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        rotate.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float r;
                FanMenuButtons.this.mRotateAngle = r = ((Float)animation.getAnimatedValue()).floatValue();
                FanMenuButtons.this.setupMatrixs();
                FanMenuButtons.this.invalidate();
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                FanMenuButtons.this.mAnimatingIn = false;
                FanMenuButtons.this.mRotateAngle = FanMenuButtons.this.mAngleBetweenButtons;
                FanMenuButtons.this.setupMatrixs();
                if (FanMenuButtons.this.mAnimListener != null) {
                    FanMenuButtons.this.mAnimListener.onAnimateOutStarted();
                }
            }

            public void onAnimationEnd(Animator animation) {
                FanMenuButtons.this.mAnimatingIn = false;
                for (int i = 0; i < FanMenuButtons.this.mButtons.length; ++i) {
                    FanMenuButtons.this.mButtons[i].left = FanMenuButtons.this.mButtonLeftStart;
                }
                FanMenuButtons.this.mRotateAngle = 0.0f;
                FanMenuButtons.this.setupMatrixs();
                FanMenuButtons.this.setVisibility(8);
                FanMenuButtons.this.mAnimationInProgress = false;
                FanMenuButtons.this.invalidate();
                if (FanMenuButtons.this.mAnimListener != null) {
                    FanMenuButtons.this.mAnimListener.onAnimateOutFinished();
                }
                FanMenuButtons.this.mAdditionalRotateAngle = 0.0f;
            }

            public void onAnimationCancel(Animator animation) {
                this.onAnimationEnd(animation);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        set.setDuration(this.mAnimationDuration);
        set.playSequentially(new Animator[]{rotate, grow});
        set.start();
        if (this.getBackground() != null) {
            alpha.start();
        }
    }

    public void setOnFanButtonClickListener(OnFanClickListener l) {
        this.mClickListener = l;
    }

    public void setOnFanAnimationListener(OnFanAnimationListener l) {
        this.mAnimListener = l;
    }

    private void setButtonSelected(int index) {
        if (this.drawables == null) {
            return;
        }
        for (int i = 0; i < this.drawables.length; ++i) {
            if (this.drawables[i] == null) {
                return;
            }
            if (i == index) {
                this.drawables[i].setState(new int[]{0x10100A1});
                continue;
            }
            this.drawables[i].setState(new int[]{16842908});
        }
        this.drawAllBitmaps();
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mClickListener == null || this.getVisibility() == 4 || this.mAnimationInProgress) {
            return false;
        }
        if (event.getAction() == 0) {
            this.mDownTime = System.currentTimeMillis();
            float x = event.getX();
            float y = event.getY();
            this.mTouchArea.left = x;
            this.mTouchArea.top = y;
            this.mTouchArea.right = this.getWidth() - this.getPaddingRight();
            this.mTouchArea.bottom = this.getHeight() - this.getPaddingBottom();
            this.mPointerDown = true;
            return true;
        }
        if (event.getAction() == 1) {
            if (System.currentTimeMillis() - this.mDownTime < 200L && !this.mIsMoving) {
                double angle = Math.toDegrees(Math.atan2(this.mTouchArea.height(), this.mTouchArea.width()));
                if (this.mTouchArea.width() < this.mButtonWidth / 2.0f && this.mTouchArea.height() < this.mButtonWidth / 2.0f && angle < (double)((float)this.menus.length * this.mRotateAngle)) {
                    this.mPointerDown = false;
                    this.animatedAdditionalRotationToZero();
                    return false;
                }
                float qtrRotation = this.mRotateAngle / 4.0f;
                for (int i = this.menus.length - 1; i >= 0; --i) {
                    float curAngle = (float)i * this.mRotateAngle + this.mAdditionalRotateAngle;
                    float nextAngle = curAngle + this.mRotateAngle;
                    if (!(angle > (double)(curAngle - qtrRotation)) || !(angle < (double)(nextAngle - qtrRotation))) continue;
                    this.setButtonSelected(i);
                    this.mClickListener.onFanButtonClicked(i);
                    this.mPointerDown = false;
                    this.animatedAdditionalRotationToZero();
                    return true;
                }
                this.animateOut();
            }
            this.mIsMoving = false;
            this.mPointerDown = false;
            this.animatedAdditionalRotationToZero();
        } else if (event.getAction() == 2) {
            boolean isPrimMoving;
            if (!this.mEnableTouchMovement) {
                return false;
            }
            boolean bl = isPrimMoving = this.mIsMoving ? this.mIsMoving : this.isScrollGesture(event, 0, this.mTouchArea.left, this.mTouchArea.top);
            if (isPrimMoving) {
                boolean add;
                this.mIsMoving = true;
                float diffPrimX = this.mTouchArea.left - event.getX(0);
                float diffPrimY = this.mTouchArea.top - event.getY(0);
                this.mTouchArea.left = event.getX(0);
                this.mTouchArea.top = event.getY(0);
                float moveBy = Math.abs(diffPrimX);
                boolean bl2 = add = diffPrimX > 0.0f;
                if (Math.abs(diffPrimX) < Math.abs(diffPrimY)) {
                    moveBy = Math.abs(diffPrimY);
                    boolean bl3 = add = diffPrimY < 0.0f;
                }
                if ((moveBy /= this.dp2) > 1.0f) {
                    moveBy = (float)((double)moveBy * 0.5);
                    this.mAdditionalRotateAngle = add ? (this.mAdditionalRotateAngle -= moveBy) : (this.mAdditionalRotateAngle += moveBy);
                    this.setupMatrixs();
                    this.invalidate();
                    return true;
                }
            }
        }
        return false;
    }

    private void animatedAdditionalRotationToZero() {
        if (this.mAdditionalRotateAngle == 0.0f || this.mAnimationInProgress) {
            return;
        }
        if (this.mRememberMovedPosition && !(this.mAdditionalRotateAngle > this.mMaxBounceBackAngle) && !(this.mAdditionalRotateAngle < this.mMinBounceBackAngle)) {
            return;
        }
        this.mAnimationInProgress = true;
        ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{this.mAdditionalRotateAngle, 0.0f});
        anim.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FanMenuButtons.this.mAdditionalRotateAngle = ((Float)animation.getAnimatedValue()).floatValue();
                FanMenuButtons.this.setupMatrixs();
                FanMenuButtons.this.invalidate();
            }
        });
        anim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                FanMenuButtons.this.mAnimationInProgress = false;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        anim.setStartDelay(this.mAnimationDuration / 2L);
        anim.start();
    }

    protected boolean isScrollGesture(MotionEvent event, int ptrIndex, float originalX, float originalY) {
        float moveX = Math.abs(event.getX(ptrIndex) - originalX);
        float moveY = Math.abs(event.getY(ptrIndex) - originalY);
        return moveX > (float)this.mViewScaledTouchSlop || moveY > (float)this.mViewScaledTouchSlop;
    }

    public static interface OnFanAnimationListener {
        public void onAnimateInStarted();

        public void onAnimateOutStarted();

        public void onAnimateInFinished();

        public void onAnimateOutFinished();
    }

    public static interface OnFanClickListener {
        public void onFanButtonClicked(int var1);
    }
}

