/*
 * Decompiled with CFR 0.152.
 */
package com.bcgdv.asia.lib.connectpattern;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import com.bcgdv.asia.lib.connectpattern.R;
import java.util.ArrayList;
import java.util.List;

public class ConnectPatternView
extends View {
    private final long ANIMATION_DURATION = 300L;
    private final int ANIMATION_TYPE_NONE = 0;
    private final int ANIMATION_TYPE_MIDDLE = 1;
    private final int ANIMATION_TYPE_BOTTOM = 2;
    private int numbersOfConnectors = 9;
    private int circleColor = -16777216;
    private int lineColor = -3355444;
    private int lineWidth = 7;
    private int radius = 14;
    private int diameter = 28;
    private int dp48 = 48;
    private int animationType = 1;
    private Drawable drawable;
    private int leftX;
    private int topY;
    private int rightX;
    private int bottomY;
    private int centerX;
    private int centerY;
    private Paint pCircle = new Paint(1);
    private Paint pLine = new Paint(1);
    private Rect touchPoint = new Rect();
    private Rect[] circles = new Rect[9];
    private int[] indexes;
    private ArrayList<Integer> connectionOrder = new ArrayList();
    private OnConnectPatternListener mPatternListener;

    public ConnectPatternView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ConnectPatternView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ConnectPatternView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ConnectPatternView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        float multi = context.getResources().getDisplayMetrics().density;
        this.lineWidth = (int)((float)this.lineWidth * multi);
        this.radius = (int)((float)this.radius * multi);
        this.diameter = (int)((float)this.diameter * multi);
        this.dp48 = (int)((float)this.dp48 * multi);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ConnectPatternView);
        try {
            this.numbersOfConnectors = typedArray.getInt(R.styleable.ConnectPatternView_connectPatternNumber, this.numbersOfConnectors);
            this.circleColor = typedArray.getColor(R.styleable.ConnectPatternView_connectPatternCircleColor, this.circleColor);
            this.radius = (int)typedArray.getDimension(R.styleable.ConnectPatternView_connectPatternCircleRadius, (float)this.radius);
            this.diameter = this.radius * 2;
            this.lineColor = typedArray.getColor(R.styleable.ConnectPatternView_connectPatternLineColor, this.lineColor);
            this.lineWidth = (int)typedArray.getDimension(R.styleable.ConnectPatternView_connectPatternLineWidth, (float)this.lineWidth);
            this.drawable = typedArray.getDrawable(R.styleable.ConnectPatternView_connectPatternDrawable);
            this.animationType = typedArray.getInt(R.styleable.ConnectPatternView_connectPatternAnimationType, this.animationType);
        }
        finally {
            typedArray.recycle();
        }
        switch (this.numbersOfConnectors) {
            case 2: {
                this.indexes = new int[]{0, 2};
                break;
            }
            case 3: {
                this.indexes = new int[]{0, 2, 4};
                break;
            }
            case 5: {
                this.indexes = new int[]{0, 2, 4, 6, 8};
                break;
            }
            case 9: {
                this.indexes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
                break;
            }
        }
        this.pCircle.setColor(this.circleColor);
        this.pLine.setColor(this.lineColor);
        this.pLine.setStrokeWidth((float)this.lineWidth);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.leftX = this.getPaddingLeft();
        this.topY = this.getPaddingTop();
        this.rightX = w - this.getPaddingRight();
        this.bottomY = h - this.getPaddingBottom();
        this.centerX = this.leftX + (this.rightX - this.leftX) / 2;
        this.centerY = this.topY + (this.bottomY - this.topY) / 2;
        this.setupCircles();
    }

    private void setupCircles() {
        this.circles[0] = new Rect(this.leftX, this.topY, this.leftX + this.diameter, this.topY + this.diameter);
        this.circles[1] = new Rect(this.centerX - this.radius, this.topY, this.centerX + this.radius, this.topY + this.diameter);
        this.circles[2] = new Rect(this.rightX - this.diameter, this.topY, this.rightX, this.topY + this.diameter);
        this.circles[3] = new Rect(this.leftX, this.centerY - this.radius, this.leftX + this.diameter, this.centerY + this.radius);
        this.circles[4] = new Rect(this.centerX - this.radius, this.centerY - this.radius, this.centerX + this.radius, this.centerY + this.radius);
        this.circles[5] = new Rect(this.rightX - this.diameter, this.centerY - this.radius, this.rightX, this.centerY + this.radius);
        this.circles[6] = new Rect(this.leftX, this.bottomY - this.diameter, this.leftX + this.diameter, this.bottomY);
        this.circles[7] = new Rect(this.centerX - this.radius, this.bottomY - this.diameter, this.centerX + this.radius, this.bottomY);
        this.circles[8] = new Rect(this.rightX - this.diameter, this.bottomY - this.diameter, this.rightX, this.bottomY);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawLines(canvas);
        this.drawLineToTouchPoint(canvas);
        this.drawCircles(canvas);
    }

    private void drawLineToTouchPoint(Canvas canvas) {
        if (this.touchPoint.height() > 0 && this.touchPoint.width() > 0) {
            this.drawLine(canvas, this.circles[this.connectionOrder.get(this.connectionOrder.size() - 1)], this.touchPoint);
        }
    }

    private void drawLines(Canvas canvas) {
        for (int i = 0; i < this.connectionOrder.size() - 1; ++i) {
            this.drawLine(canvas, this.circles[this.connectionOrder.get(i)], this.circles[this.connectionOrder.get(i + 1)]);
        }
    }

    private void drawCircles(Canvas canvas) {
        for (int i = 0; i < this.indexes.length; ++i) {
            int circleNumber = this.indexes[i];
            if (this.drawable == null) {
                canvas.drawCircle((float)this.circles[circleNumber].centerX(), (float)this.circles[circleNumber].centerY(), (float)this.radius, this.pCircle);
                continue;
            }
            this.drawable.setBounds(this.circles[circleNumber]);
            this.drawable.draw(canvas);
        }
    }

    private void drawLine(Canvas canvas, Rect start, Rect end) {
        canvas.drawLine((float)start.centerX(), (float)start.centerY(), (float)end.centerX(), (float)end.centerY(), this.pLine);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.setTouchPoint(event);
                for (int i = 0; i < this.indexes.length; ++i) {
                    int circleNumber = this.indexes[i];
                    if (!this.touchPoint.intersect(this.circles[circleNumber])) continue;
                    this.connectionOrder.add(circleNumber);
                    return true;
                }
                break;
            }
            case 2: {
                this.setTouchPoint(event);
                for (int i = 0; i < this.indexes.length; ++i) {
                    int circleNumber = this.indexes[i];
                    if (!this.touchPoint.intersect(this.circles[circleNumber]) || this.connectionOrder.contains(circleNumber)) continue;
                    this.connectionOrder.add(circleNumber);
                }
                this.invalidate();
                return true;
            }
            case 1: {
                this.setEnabled(false);
                this.touchPoint.left = 0;
                this.touchPoint.right = 0;
                this.touchPoint.top = 0;
                this.touchPoint.bottom = 0;
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ConnectPatternView.this.setEnabled(true);
                        if (ConnectPatternView.this.mPatternListener != null) {
                            if (ConnectPatternView.this.connectionOrder.size() > 1) {
                                ConnectPatternView.this.mPatternListener.onPatternEntered(ConnectPatternView.this.connectionOrder);
                            } else {
                                ConnectPatternView.this.mPatternListener.onPatternAbandoned();
                            }
                        }
                        ConnectPatternView.this.connectionOrder.clear();
                        ConnectPatternView.this.invalidate();
                    }
                }, 300L);
                return true;
            }
            case 3: {
                break;
            }
        }
        return false;
    }

    private void setTouchPoint(MotionEvent event) {
        this.touchPoint.left = (int)event.getX();
        this.touchPoint.top = (int)event.getY();
        this.touchPoint.bottom = this.touchPoint.top + this.dp48;
        this.touchPoint.right = this.touchPoint.left + this.dp48;
    }

    public void animateIn() {
        this.animateIn(0L);
    }

    public void animateIn(final long delay) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getVisibility() == 8) {
            this.setVisibility(4);
        }
        if (this.circles[0] == null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConnectPatternView.this.animateIn(delay);
                }
            }, 300L);
            return;
        }
        List<Animator> animators = this.animationType == 1 ? this.animateInFromMiddle() : this.animateInFromBottom();
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        set.setDuration(this.animationType == 0 ? 0L : 300L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                ConnectPatternView.this.setEnabled(false);
                ConnectPatternView.this.setVisibility(0);
                if (ConnectPatternView.this.mPatternListener != null) {
                    ConnectPatternView.this.mPatternListener.animateInStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                ConnectPatternView.this.setEnabled(true);
                if (ConnectPatternView.this.mPatternListener != null) {
                    ConnectPatternView.this.mPatternListener.animateInEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        set.setStartDelay(delay);
        set.start();
    }

    private List<Animator> animateInFromMiddle() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        for (int i = 0; i < this.indexes.length; ++i) {
            int circleNumber = this.indexes[i];
            ValueAnimator leftAnim = ValueAnimator.ofInt((int[])new int[]{this.circles[4].left, this.circles[circleNumber].left});
            leftAnim.setInterpolator((TimeInterpolator)new OvershootInterpolator());
            leftAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                Rect circle = null;

                public void onAnimationUpdate(ValueAnimator animation) {
                    int left;
                    this.circle.left = left = ((Integer)animation.getAnimatedValue()).intValue();
                    this.circle.right = left + ConnectPatternView.this.diameter;
                }

                public ValueAnimator.AnimatorUpdateListener init(Rect rect) {
                    this.circle = rect;
                    return this;
                }
            }.init(this.circles[circleNumber]));
            animators.add((Animator)leftAnim);
            ValueAnimator topAnim = ValueAnimator.ofInt((int[])new int[]{this.circles[4].top, this.circles[circleNumber].top});
            topAnim.setInterpolator((TimeInterpolator)new OvershootInterpolator());
            topAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                Rect circle = null;

                public void onAnimationUpdate(ValueAnimator animation) {
                    int top;
                    this.circle.top = top = ((Integer)animation.getAnimatedValue()).intValue();
                    this.circle.bottom = top + ConnectPatternView.this.diameter;
                    ConnectPatternView.this.invalidate();
                }

                public ValueAnimator.AnimatorUpdateListener init(Rect rect) {
                    this.circle = rect;
                    return this;
                }
            }.init(this.circles[circleNumber]));
            animators.add((Animator)topAnim);
        }
        return animators;
    }

    private List<Animator> animateInFromBottom() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        int height = this.getHeight();
        if (height <= 0) {
            height = this.getResources().getDisplayMetrics().heightPixels;
        }
        for (int i = 0; i < this.indexes.length; ++i) {
            int circleNumber = this.indexes[i];
            int originalTop = this.circles[circleNumber].top;
            this.circles[circleNumber].top = height;
            this.circles[circleNumber].bottom = height + this.diameter;
            ValueAnimator topAnim = ValueAnimator.ofInt((int[])new int[]{height, originalTop});
            topAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            topAnim.setStartDelay(300L / (long)this.indexes.length * (long)(i % 3));
            topAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                Rect circle = null;

                public void onAnimationUpdate(ValueAnimator animation) {
                    int top;
                    this.circle.top = top = ((Integer)animation.getAnimatedValue()).intValue();
                    this.circle.bottom = top + ConnectPatternView.this.diameter;
                    ConnectPatternView.this.invalidate();
                }

                public ValueAnimator.AnimatorUpdateListener init(Rect rect) {
                    this.circle = rect;
                    return this;
                }
            }.init(this.circles[circleNumber]));
            animators.add((Animator)topAnim);
        }
        this.invalidate();
        return animators;
    }

    public void animateOut() {
        this.animateOut(0L);
    }

    public void animateOut(final long delay) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.circles[0] == null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConnectPatternView.this.animateOut(delay);
                }
            }, 300L);
            return;
        }
        List<Animator> animators = this.animationType == 1 ? this.animateOutToMiddle() : this.animateOutToBottom();
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        set.setDuration(this.animationType == 0 ? 0L : 300L);
        set.setStartDelay(delay);
        set.start();
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                ConnectPatternView.this.setEnabled(false);
                if (ConnectPatternView.this.mPatternListener != null) {
                    ConnectPatternView.this.mPatternListener.animateOutStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                ConnectPatternView.this.setEnabled(true);
                if (ConnectPatternView.this.mPatternListener != null) {
                    ConnectPatternView.this.mPatternListener.animateOutEnd();
                }
                ConnectPatternView.this.setupCircles();
            }

            public void onAnimationCancel(Animator animation) {
                this.onAnimationEnd(animation);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private List<Animator> animateOutToBottom() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        int height = this.getHeight();
        if (height <= 0) {
            height = this.getResources().getDisplayMetrics().heightPixels;
        }
        int totalLength = this.indexes.length;
        for (int i = 0; i < totalLength; ++i) {
            int circleNumber = this.indexes[i];
            ValueAnimator topAnim = ValueAnimator.ofInt((int[])new int[]{this.circles[circleNumber].top, height});
            topAnim.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            if (this.animationType != 0) {
                topAnim.setStartDelay(300L / (long)this.indexes.length * (long)(i % 3));
            }
            topAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                Rect circle = null;

                public void onAnimationUpdate(ValueAnimator animation) {
                    int top;
                    this.circle.top = top = ((Integer)animation.getAnimatedValue()).intValue();
                    this.circle.bottom = top + ConnectPatternView.this.diameter;
                    ConnectPatternView.this.invalidate();
                }

                public ValueAnimator.AnimatorUpdateListener init(Rect rect) {
                    this.circle = rect;
                    return this;
                }
            }.init(this.circles[circleNumber]));
            animators.add((Animator)topAnim);
        }
        return animators;
    }

    private List<Animator> animateOutToMiddle() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        for (int i = 0; i < this.indexes.length; ++i) {
            int circleNumber = this.indexes[i];
            ValueAnimator leftAnim = ValueAnimator.ofInt((int[])new int[]{this.circles[circleNumber].left, this.circles[4].left});
            leftAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            if (this.animationType != 0) {
                leftAnim.setStartDelay(300L / (long)this.indexes.length * (long)i);
            }
            leftAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                Rect circle = null;

                public void onAnimationUpdate(ValueAnimator animation) {
                    int left;
                    this.circle.left = left = ((Integer)animation.getAnimatedValue()).intValue();
                    this.circle.right = left + ConnectPatternView.this.diameter;
                }

                public ValueAnimator.AnimatorUpdateListener init(Rect rect) {
                    this.circle = rect;
                    return this;
                }
            }.init(this.circles[circleNumber]));
            animators.add((Animator)leftAnim);
            ValueAnimator topAnim = ValueAnimator.ofInt((int[])new int[]{this.circles[circleNumber].top, this.circles[4].top});
            topAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            if (this.animationType != 0) {
                topAnim.setStartDelay(300L / (long)this.indexes.length * (long)i);
            }
            topAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                Rect circle = null;

                public void onAnimationUpdate(ValueAnimator animation) {
                    int top;
                    this.circle.top = top = ((Integer)animation.getAnimatedValue()).intValue();
                    this.circle.bottom = top + ConnectPatternView.this.diameter;
                    ConnectPatternView.this.invalidate();
                }

                public ValueAnimator.AnimatorUpdateListener init(Rect rect) {
                    this.circle = rect;
                    return this;
                }
            }.init(this.circles[circleNumber]));
            animators.add((Animator)topAnim);
        }
        return animators;
    }

    public void setOnConnectPatternListener(OnConnectPatternListener l) {
        this.mPatternListener = l;
    }

    public static interface OnConnectPatternListener {
        public void onPatternEntered(ArrayList<Integer> var1);

        public void onPatternAbandoned();

        public void animateInStart();

        public void animateInEnd();

        public void animateOutStart();

        public void animateOutEnd();
    }
}

