/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.handler.ESExceptionWrapper;
import org.frameworkset.spi.remote.http.BaseResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExceptionResponseHandler
extends BaseResponseHandler
implements ESExceptionWrapper {
    protected ElasticSearchException elasticSearchException;
    protected static Logger _logger = LoggerFactory.getLogger(BaseExceptionResponseHandler.class);

    @Override
    public ElasticSearchException getElasticSearchException() {
        return this.elasticSearchException;
    }

    protected Object handleException(String url, HttpEntity entity, int status) throws IOException {
        if (status == 404) {
            if (entity != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Request url:" + url + ",status:" + status);
                }
                this.elasticSearchException = new ElasticSearchException(EntityUtils.toString((HttpEntity)entity), status);
            } else {
                this.elasticSearchException = new ElasticSearchException("Request url:" + url + ",Unexpected response status: " + status, status);
            }
            return null;
        }
        if (entity != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new ElasticSearchException(EntityUtils.toString((HttpEntity)entity), status);
        }
        throw new ElasticSearchException("Request url:" + url + ",Unexpected response status: " + status, status);
    }
}

