/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.frameworkset.common.poolman.BatchHandler;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.DefualtExportResultHandler;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.db.DBExportBuilder;
import org.frameworkset.tran.es.input.db.ES2DBDataStreamImpl;
import org.frameworkset.tran.es.input.db.ES2DBImportConfig;

public class ES2DBExportBuilder
extends DBExportBuilder {
    private String scrollLiveTime = "100m";
    private transient BatchHandler<Map> batchHandler;
    private String batchHandlerClass;
    private Map params;
    private String queryUrl;
    private String dsl2ndSqlFile;
    private String dslName;
    private boolean sliceQuery;
    private int sliceSize;

    @Override
    protected WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        return new DefualtExportResultHandler(exportResultHandler);
    }

    @Override
    public DataStream builder() {
        super.builderConfig();
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ES2DB Import Configs:");
                this.logger.info(this.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ES2DBImportConfig es2DBImportConfig = new ES2DBImportConfig();
        super.buildImportConfig(es2DBImportConfig);
        es2DBImportConfig.setDsl2ndSqlFile(this.dsl2ndSqlFile);
        if (this.getSqlFilepath() == null) {
            this.setSqlFilepath(this.dsl2ndSqlFile);
        }
        super.buildDBImportConfig(es2DBImportConfig);
        es2DBImportConfig.setQueryUrl(this.queryUrl);
        es2DBImportConfig.setScrollLiveTime(this.scrollLiveTime);
        es2DBImportConfig.setBatchHandler(this.batchHandler);
        es2DBImportConfig.setDslName(this.dslName);
        es2DBImportConfig.setSliceQuery(this.sliceQuery);
        es2DBImportConfig.setSliceSize(this.sliceSize);
        es2DBImportConfig.setParams(this.params);
        ES2DBDataStreamImpl dataStream = new ES2DBDataStreamImpl();
        dataStream.setImportConfig(es2DBImportConfig);
        return dataStream;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public ES2DBExportBuilder setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
        return this;
    }

    @JsonIgnore
    public BatchHandler<Map> getBatchHandler() {
        return this.batchHandler;
    }

    public ES2DBExportBuilder setBatchHandler(BatchHandler<Map> batchHandler) {
        this.batchHandler = batchHandler;
        if (batchHandler != null) {
            this.batchHandlerClass = batchHandler.getClass().getName();
        }
        return this;
    }

    public String getDsl2ndSqlFile() {
        return this.dsl2ndSqlFile;
    }

    public ES2DBExportBuilder setDsl2ndSqlFile(String dsl2ndSqlFile) {
        this.dsl2ndSqlFile = dsl2ndSqlFile;
        return this;
    }

    public String getDslName() {
        return this.dslName;
    }

    public ES2DBExportBuilder setDslName(String dslName) {
        this.dslName = dslName;
        return this;
    }

    public String getScrollLiveTime() {
        return this.scrollLiveTime;
    }

    public ES2DBExportBuilder setScrollLiveTime(String scrollLiveTime) {
        this.scrollLiveTime = scrollLiveTime;
        return this;
    }

    public boolean isSliceQuery() {
        return this.sliceQuery;
    }

    public ES2DBExportBuilder setSliceQuery(boolean sliceQuery) {
        this.sliceQuery = sliceQuery;
        return this;
    }

    public int getSliceSize() {
        return this.sliceSize;
    }

    public ES2DBExportBuilder setSliceSize(int sliceSize) {
        this.sliceSize = sliceSize;
        return this;
    }

    public ES2DBExportBuilder addParam(String key, Object value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(key, value);
        return this;
    }

    public String getBatchHandlerClass() {
        return this.batchHandlerClass;
    }
}

