/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.db;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.SQLBaseDataTranPlugin;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.es.BaseESExporterScrollHandler;
import org.frameworkset.tran.es.ES2TranResultSet;
import org.frameworkset.tran.es.input.db.ES2DBContext;
import org.frameworkset.tran.es.input.db.ES2DBOutPutDataTran;
import org.frameworkset.tran.es.input.db.ESDirectExporterScrollHandler;
import org.frameworkset.tran.es.input.db.ESExporterScrollHandler;
import org.frameworkset.tran.util.TranUtil;

public class ES2DBDataTranPlugin
extends SQLBaseDataTranPlugin
implements DataTranPlugin {
    private ES2DBContext es2DBContext;

    @Override
    protected void init(ImportContext importContext) {
        super.init(importContext);
        this.es2DBContext = (ES2DBContext)((Object)importContext);
    }

    public ES2DBDataTranPlugin(ImportContext importContext) {
        super(importContext);
    }

    @Override
    public void beforeInit() {
        this.initES(this.importContext.getApplicationPropertiesFile());
        this.initDS(this.importContext.getDbConfig());
        this.initOtherDSes(this.importContext.getConfigs());
    }

    @Override
    public void afterInit() {
        TranUtil.initTargetSQLInfo(this.es2DBContext, this.importContext.getDbConfig(), this.es2DBContext.getSqlName());
    }

    @Override
    public void initStatusTableId() {
        if (this.isIncreamentImport() && this.es2DBContext.getDslFile() != null && !this.es2DBContext.getDslFile().equals("")) {
            try {
                ClientInterface clientInterface = ElasticSearchHelper.getConfigRestClientUtil((String)this.importContext.getSourceElasticsearch(), (String)this.es2DBContext.getDslFile());
                ESInfo esInfo = clientInterface.getESInfo(this.es2DBContext.getDslName());
                this.importContext.setStatusTableId(esInfo.getTemplate().hashCode());
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    private void commonImportData(BaseESExporterScrollHandler<Map> esExporterScrollHandler) throws Exception {
        Map<String, Integer> params = this.es2DBContext.getParams() != null ? this.es2DBContext.getParams() : new HashMap();
        params.put("size", this.importContext.getFetchSize());
        if (this.es2DBContext.isSliceQuery()) {
            params.put("sliceMax", this.es2DBContext.getSliceSize());
        }
        this.exportESData(esExporterScrollHandler, params);
    }

    private void exportESData(BaseESExporterScrollHandler<Map> esExporterScrollHandler, Map params) {
        ClientInterface clientUtil = ElasticSearchHelper.getConfigRestClientUtil((String)this.importContext.getSourceElasticsearch(), (String)this.es2DBContext.getDslFile());
        ESDatas response = null;
        response = !this.es2DBContext.isSliceQuery() ? (this.importContext.isParallel() && esExporterScrollHandler instanceof ESDirectExporterScrollHandler ? clientUtil.scrollParallel(this.es2DBContext.getQueryUrl(), this.es2DBContext.getDslName(), this.es2DBContext.getScrollLiveTime(), params, Map.class, esExporterScrollHandler) : clientUtil.scroll(this.es2DBContext.getQueryUrl(), this.es2DBContext.getDslName(), this.es2DBContext.getScrollLiveTime(), params, Map.class, esExporterScrollHandler)) : clientUtil.scrollSliceParallel(this.es2DBContext.getQueryUrl(), this.es2DBContext.getDslName(), params, this.es2DBContext.getScrollLiveTime(), Map.class, esExporterScrollHandler);
        if (this.logger.isInfoEnabled()) {
            if (response != null) {
                this.logger.info("Export compoleted and export total {} records.", (Object)response.getTotalSize());
            } else {
                this.logger.info("Export compoleted and export no records or failed.");
            }
        }
    }

    private void increamentImportData(BaseESExporterScrollHandler<Map> esExporterScrollHandler) throws Exception {
        Map<String, Integer> params = this.es2DBContext.getParams() != null ? this.es2DBContext.getParams() : new HashMap();
        params.put("size", this.importContext.getFetchSize());
        if (this.es2DBContext.isSliceQuery()) {
            params.put("sliceMax", this.es2DBContext.getSliceSize());
        }
        this.putLastParamValue(params);
        this.exportESData(esExporterScrollHandler, params);
    }

    @Override
    public void doImportData() throws ESDataImportException {
        if (this.es2DBContext.getBatchHandler() != null) {
            ESDirectExporterScrollHandler<Map> esDirectExporterScrollHandler = new ESDirectExporterScrollHandler<Map>(this.importContext, this.executor);
            try {
                if (!this.isIncreamentImport()) {
                    this.commonImportData(esDirectExporterScrollHandler);
                }
                this.increamentImportData(esDirectExporterScrollHandler);
            }
            catch (ESDataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        } else {
            ES2TranResultSet jdbcResultSet = new ES2TranResultSet(this.importContext);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            final ES2DBOutPutDataTran es2DBDataTran = new ES2DBOutPutDataTran(jdbcResultSet, this.importContext, countDownLatch);
            ESExporterScrollHandler<Map> esExporterScrollHandler = new ESExporterScrollHandler<Map>(this.importContext, es2DBDataTran);
            try {
                Thread tranThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        es2DBDataTran.tran();
                    }
                }, "Elasticsearch-DB-Tran");
                tranThread.start();
                if (!this.isIncreamentImport()) {
                    this.commonImportData(esExporterScrollHandler);
                } else {
                    this.increamentImportData(esExporterScrollHandler);
                }
            }
            catch (ESDataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
            finally {
                block19: {
                    jdbcResultSet.reachEend();
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException e) {
                        if (!this.logger.isErrorEnabled()) break block19;
                        this.logger.error("", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public String getLastValueVarName() {
        return this.importContext.getLastValueClumnName();
    }
}

