/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.config;

import com.frameworkset.orm.annotation.ESIndexWrapper;
import java.text.DateFormat;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.spi.geoip.GeoIPUtil;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.DefaultEsIdGenerator;
import org.frameworkset.tran.EsIdGenerator;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.es.ESConfig;
import org.frameworkset.tran.es.ESField;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.ImportIncreamentConfig;
import org.frameworkset.tran.schedule.ScheduleConfig;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseImportConfig {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<DBConfig> configs;
    private boolean sortLastValue;
    private long flushInterval;
    private long asynResultPollTimeOut = 1000L;
    private String sourceElasticsearch = "default";
    private ESConfig esConfig;
    private String targetElasticsearch;
    private boolean ignoreNullValueField;
    private Integer fetchSize = 5000;
    private int tranDataBufferQueue = 10;
    public static EsIdGenerator DEFAULT_EsIdGenerator = new DefaultEsIdGenerator();
    private EsIdGenerator esIdGenerator = DEFAULT_EsIdGenerator;
    private ClientOptions clientOptions;
    private DBConfig dbConfig;
    private DBConfig statusDbConfig;
    protected boolean pagine;
    private boolean printTaskLog = false;
    private List<CallInterceptor> callInterceptors;
    private WrapedExportResultHandler exportResultHandler;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = Integer.MAX_VALUE;
    private String applicationPropertiesFile;
    private Boolean useJavaName;
    private Boolean useLowcase;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private DateFormat format;
    private Map<String, FieldMeta> fieldMetaMap;
    private List<FieldMeta> fieldValues;
    private DataRefactor dataRefactor;
    private int batchSize;
    private Integer scheduleBatchSize;
    private ESIndexWrapper esIndexWrapper;
    private boolean asyn;
    private boolean continueOnError;
    private boolean discardBulkResponse = true;
    private boolean debugResponse;
    private ScheduleConfig scheduleConfig;
    private ImportIncreamentConfig importIncreamentConfig;

    public void setTargetElasticsearch(String targetElasticsearch) {
        this.targetElasticsearch = targetElasticsearch;
    }

    public String getSourceElasticsearch() {
        return this.sourceElasticsearch;
    }

    public void setSourceElasticsearch(String sourceElasticsearch) {
        this.sourceElasticsearch = sourceElasticsearch;
    }

    public boolean isIgnoreNullValueField() {
        return this.ignoreNullValueField;
    }

    public long getAsynResultPollTimeOut() {
        return this.asynResultPollTimeOut;
    }

    public void setAsynResultPollTimeOut(long asynResultPollTimeOut) {
        this.asynResultPollTimeOut = asynResultPollTimeOut;
    }

    public void setIgnoreNullValueField(boolean ignoreNullValueField) {
        this.ignoreNullValueField = ignoreNullValueField;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setTranDataBufferQueue(int tranDataBufferQueue) {
        this.tranDataBufferQueue = tranDataBufferQueue;
    }

    public boolean isPagine() {
        return this.pagine;
    }

    public void setPagine(boolean pagine) {
        this.pagine = pagine;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public Boolean getUseLowcase() {
        return this.useLowcase;
    }

    public void setUseLowcase(Boolean useLowcase) {
        this.useLowcase = useLowcase;
    }

    public ESIndexWrapper getEsIndexWrapper() {
        return this.esIndexWrapper;
    }

    public void setEsIndexWrapper(ESIndexWrapper esIndexWrapper) {
        this.esIndexWrapper = esIndexWrapper;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public void setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
    }

    public DateFormateMeta getDateFormateMeta() {
        return DateFormateMeta.buildDateFormateMeta((String)this.dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public DateFormat getFormat() {
        if (this.format == null) {
            DateFormateMeta dateFormateMeta = this.getDateFormateMeta();
            if (dateFormateMeta == null) {
                dateFormateMeta = SerialUtil.getDateFormateMeta();
            }
            this.format = dateFormateMeta.toDateFormat();
        }
        return this.format;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    public void destroy() {
        this.format = null;
    }

    public void setFieldMetaMap(Map<String, FieldMeta> fieldMetaMap) {
        this.fieldMetaMap = fieldMetaMap;
    }

    public FieldMeta getMappingName(String colName) {
        if (this.fieldMetaMap != null) {
            return this.fieldMetaMap.get(colName.toLowerCase());
        }
        return null;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public void setAsyn(boolean asyn) {
        this.asyn = asyn;
    }

    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(List<FieldMeta> fieldValues) {
        this.fieldValues = fieldValues;
    }

    public DataRefactor getDataRefactor() {
        return this.dataRefactor;
    }

    public void setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
    }

    public boolean isDiscardBulkResponse() {
        return this.discardBulkResponse;
    }

    public void setDiscardBulkResponse(boolean discardBulkResponse) {
        this.discardBulkResponse = discardBulkResponse;
    }

    public boolean isDebugResponse() {
        return this.debugResponse;
    }

    public void setDebugResponse(boolean debugResponse) {
        this.debugResponse = debugResponse;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public void setScheduleConfig(ScheduleConfig scheduleConfig) {
        this.scheduleConfig = scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    public void setStatusTableId(Integer statusTableId) {
        if (this.importIncreamentConfig != null) {
            this.importIncreamentConfig.setStatusTableId(statusTableId);
        }
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public void setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
    }

    public boolean isFromFirst() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.isFromFirst() : false;
    }

    public String getLastValueStoreTableName() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueStoreTableName() : null;
    }

    public String getLastValueStorePath() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueStorePath() : null;
    }

    public String getDateLastValueColumn() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getDateLastValueColumn() : null;
    }

    public String getNumberLastValueColumn() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getNumberLastValueColumn() : null;
    }

    public Integer getLastValueType() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueType() : null;
    }

    public Object getConfigLastValue() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValue() : null;
    }

    public Integer getStatusTableId() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getStatusTableId() : null;
    }

    public void stop() {
    }

    public List<CallInterceptor> getCallInterceptors() {
        return this.callInterceptors;
    }

    public void setCallInterceptors(List<CallInterceptor> callInterceptors) {
        this.callInterceptors = callInterceptors;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public void setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
    }

    public EsIdGenerator getEsIdGenerator() {
        return this.esIdGenerator;
    }

    public void setEsIdGenerator(EsIdGenerator esIdGenerator) {
        if (esIdGenerator != null) {
            this.esIdGenerator = esIdGenerator;
        }
    }

    public DBConfig getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(DBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public WrapedExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public void setExportResultHandler(WrapedExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
    }

    public int getMaxRetry() {
        if (this.exportResultHandler != null) {
            return this.exportResultHandler.getMaxRetry();
        }
        return -1;
    }

    public DBConfig getStatusDbConfig() {
        return this.statusDbConfig;
    }

    public void setStatusDbConfig(DBConfig statusDbConfig) {
        this.statusDbConfig = statusDbConfig;
    }

    public static GeoIPUtil getGeoIPUtil() {
        return GeoIPUtil.getGeoIPUtil();
    }

    public void setExternalTimer(boolean externalTimer) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setExternalTimer(externalTimer);
    }

    public List<DBConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<DBConfig> configs) {
        this.configs = configs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setImportIncreamentConfig(ImportIncreamentConfig importIncreamentConfig) {
        this.importIncreamentConfig = importIncreamentConfig;
    }

    public boolean isExternalTimer() {
        if (this.scheduleConfig != null) {
            return this.scheduleConfig.isExternalTimer();
        }
        return false;
    }

    public void setLastValueType(int lastValueType) {
        this.importIncreamentConfig.setLastValueType(lastValueType);
    }

    public boolean isLastValueDateType() {
        return this.getLastValueType() == 1;
    }

    public boolean isSortLastValue() {
        return this.sortLastValue;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public void setSortLastValue(boolean sortLastValue) {
        this.sortLastValue = sortLastValue;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public int getTranDataBufferQueue() {
        return this.tranDataBufferQueue;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public void setEsIdField(ESField esIdField) {
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
        this.clientOptions.setIdField(esIdField);
    }

    public void setRefreshOption(String refreshOption) {
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
        this.clientOptions.setRefreshOption(refreshOption);
    }

    public String getTargetElasticsearch() {
        return this.targetElasticsearch;
    }

    public ESConfig getESConfig() {
        return this.esConfig;
    }

    public void setEsConfig(ESConfig esConfig) {
        this.esConfig = esConfig;
    }
}

