/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockedTaskRejectedExecutionHandler
implements RejectedExecutionHandler {
    private static Logger logger = LoggerFactory.getLogger(BlockedTaskRejectedExecutionHandler.class);
    private AtomicInteger rejectCounts;

    public BlockedTaskRejectedExecutionHandler(AtomicInteger rejectCounts) {
        this.rejectCounts = rejectCounts;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        int t;
        int counts = this.rejectCounts.incrementAndGet();
        if (logger.isWarnEnabled() && (t = counts % 100) == 0) {
            logger.warn("Task[Import DB Data to Elasticsearch] rejected  " + counts + " times.");
        }
        try {
            executor.getQueue().put(r);
        }
        catch (InterruptedException e1) {
            throw new RejectedExecutionException(e1);
        }
    }
}

