/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.boot.ElasticSearchBoot;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.ExportCount;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataTranPlugin
implements DataTranPlugin {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean increamentImport = true;
    private ExportCount exportCount;
    protected ImportContext importContext;
    protected volatile Status currentStatus;
    protected volatile Status firstStatus;
    protected String updateSQL;
    protected String insertSQL;
    protected String createStatusTableSQL;
    protected String selectSQL;
    protected String existSQL;
    protected int lastValueType = 0;
    protected Date initLastDate = null;
    protected String statusDbname;
    protected String statusTableName;
    protected String statusStorePath;
    protected String lastValueClumnName;
    protected ScheduleService scheduleService;
    private TranErrorWrapper errorWrapper;
    private volatile boolean forceStop = false;

    @Override
    public ExportCount getExportCount() {
        return this.exportCount;
    }

    @Override
    public Long getTimeRangeLastValue() {
        return null;
    }

    public BaseDataTranPlugin(ImportContext importContext) {
        this.importContext = importContext;
        this.init(importContext);
    }

    protected void init(ImportContext importContext) {
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    protected boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && this.logger.isInfoEnabled();
    }

    @Override
    public void importData() throws ESDataImportException {
        if (this.scheduleService == null) {
            long importStartTime = System.currentTimeMillis();
            this.doImportData();
            long importEndTime = System.currentTimeMillis();
            if (this.isPrintTaskLog()) {
                this.logger.info("Execute job Take " + (importEndTime - importStartTime) + " ms");
            }
        } else {
            try {
                if (!this.importContext.isExternalTimer()) {
                    this.scheduleService.timeSchedule(this.importContext);
                } else {
                    this.scheduleService.externalTimeSchedule(this.importContext);
                }
            }
            catch (ESDataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    public abstract void beforeInit();

    public abstract void afterInit();

    public abstract void initStatusTableId();

    @Override
    public void init() {
        this.exportCount = new ExportCount();
        this.beforeInit();
        this.initSchedule();
        this.initLastValueClumnName();
        this.initStatusStore();
        this.initDatasource();
        if (this.isIncreamentImport() && this.importContext.getStatusTableId() == null) {
            this.initStatusTableId();
        }
        this.initTableAndStatus();
        this.afterInit();
    }

    @Override
    public String getLastValueClumnName() {
        return this.lastValueClumnName;
    }

    @Override
    public boolean isContinueOnError() {
        return this.importContext.isContinueOnError();
    }

    @Override
    public void destroy() {
        if (this.scheduleService != null) {
            this.scheduleService.stop();
        }
        try {
            if (this.statusDbname != null && !this.statusDbname.equals("")) {
                SQLUtil.stopPool((String)this.statusDbname);
            }
        }
        catch (Exception e) {
            this.logger.error("Stop status db pool[" + this.statusDbname + "] failed:", (Throwable)e);
        }
        this.stopDS(this.importContext.getDbConfig());
        this.stopOtherDSES(this.importContext.getConfigs());
    }

    public void putLastParamValue(Map params) {
        if (this.lastValueType == 0) {
            params.put(this.getLastValueVarName(), this.currentStatus.getLastValue());
        } else if (this.currentStatus.getLastValue() instanceof Date) {
            params.put(this.getLastValueVarName(), this.currentStatus.getLastValue());
        } else if (this.currentStatus.getLastValue() instanceof Long) {
            params.put(this.getLastValueVarName(), new Date((Long)this.currentStatus.getLastValue()));
        } else if (this.currentStatus.getLastValue() instanceof Integer) {
            params.put(this.getLastValueVarName(), new Date(((Integer)this.currentStatus.getLastValue()).longValue()));
        } else if (this.currentStatus.getLastValue() instanceof Short) {
            params.put(this.getLastValueVarName(), new Date(((Short)this.currentStatus.getLastValue()).longValue()));
        } else {
            params.put(this.getLastValueVarName(), new Date(((Number)this.currentStatus.getLastValue()).longValue()));
        }
        if (this.isPrintTaskLog()) {
            this.logger.info("Current values: " + params);
        }
    }

    public Map getParamValue() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.lastValueType == 0) {
            params.put(this.getLastValueVarName(), this.currentStatus.getLastValue());
        } else if (this.currentStatus.getLastValue() instanceof Date) {
            params.put(this.getLastValueVarName(), this.currentStatus.getLastValue());
        } else if (this.currentStatus.getLastValue() instanceof Long) {
            params.put(this.getLastValueVarName(), new Date((Long)this.currentStatus.getLastValue()));
        } else if (this.currentStatus.getLastValue() instanceof Integer) {
            params.put(this.getLastValueVarName(), new Date(((Integer)this.currentStatus.getLastValue()).longValue()));
        } else if (this.currentStatus.getLastValue() instanceof Short) {
            params.put(this.getLastValueVarName(), new Date(((Short)this.currentStatus.getLastValue()).longValue()));
        } else {
            params.put(this.getLastValueVarName(), new Date(((Number)this.currentStatus.getLastValue()).longValue()));
        }
        if (this.isPrintTaskLog()) {
            this.logger.info("Current values: " + params);
        }
        return params;
    }

    public void initLastValueClumnName() {
        if (this.lastValueClumnName != null) {
            return;
        }
        if (this.importContext.getDateLastValueColumn() != null) {
            this.lastValueClumnName = this.importContext.getDateLastValueColumn();
        } else if (this.importContext.getNumberLastValueColumn() != null) {
            this.lastValueClumnName = this.importContext.getNumberLastValueColumn();
        } else if (this.getLastValueVarName() != null) {
            this.lastValueClumnName = this.getLastValueVarName();
        }
        if (this.lastValueClumnName == null) {
            this.setIncreamentImport(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initLastValueStatus(boolean update) throws Exception {
        Status currentStatus;
        block10: {
            block11: {
                block12: {
                    currentStatus = new Status();
                    currentStatus.setId(this.importContext.getStatusTableId());
                    currentStatus.setTime(new Date().getTime());
                    if (this.lastValueType != 1) break block11;
                    if (this.importContext.getConfigLastValue() == null) break block12;
                    if (this.importContext.getConfigLastValue() instanceof Long) {
                        currentStatus.setLastValue(new Date((Long)this.importContext.getConfigLastValue()));
                        break block10;
                    } else if (this.importContext.getConfigLastValue() instanceof Date) {
                        currentStatus.setLastValue(this.importContext.getConfigLastValue());
                        break block10;
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("TIMESTAMP TYPE Last Value Illegal:{}", this.importContext.getConfigLastValue());
                        }
                        throw new ESDataImportException("TIMESTAMP TYPE Last Value Illegal:" + this.importContext.getConfigLastValue());
                    }
                }
                currentStatus.setLastValue(this.initLastDate);
                break block10;
            }
            if (this.importContext.getConfigLastValue() != null) {
                currentStatus.setLastValue(this.importContext.getConfigLastValue());
            } else {
                currentStatus.setLastValue(0);
            }
        }
        currentStatus.setLastValueType(this.lastValueType);
        if (!update) {
            this.addStatus(currentStatus);
        } else {
            this.updateStatus(currentStatus);
        }
        this.currentStatus = currentStatus;
        this.firstStatus = (Status)currentStatus.clone();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Init LastValue Status: {}", (Object)currentStatus.toString());
        }
    }

    protected void initTableAndStatus() {
        if (this.isIncreamentImport()) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.initLastDate = dateFormat.parse("1970-01-01");
                SQLExecutor.queryObjectWithDBName(Integer.TYPE, (String)this.statusDbname, (String)this.existSQL, (Object[])new Object[0]);
            }
            catch (Exception e) {
                String tsql = this.createStatusTableSQL;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} table not exist\uff0c{}\uff1a{}.", new Object[]{this.statusTableName, this.statusTableName, tsql});
                }
                try {
                    SQLExecutor.updateWithDBName((String)this.statusDbname, (String)tsql, (Object[])new Object[0]);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("table " + this.statusTableName + " create success\uff1a" + tsql + ".");
                    }
                }
                catch (Exception e1) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("table " + this.statusTableName + " create success\uff1a" + tsql + ".", (Throwable)e1);
                    }
                    throw new ESDataImportException(e1);
                }
            }
            try {
                Object lastValue;
                this.currentStatus = (Status)SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.selectSQL, (Object[])new Object[]{this.importContext.getStatusTableId()});
                if (this.currentStatus == null) {
                    this.initLastValueStatus(false);
                }
                if (this.importContext.isFromFirst()) {
                    this.initLastValueStatus(true);
                }
                if (this.currentStatus.getLastValueType() == 1 && (lastValue = this.currentStatus.getLastValue()) instanceof Long) {
                    this.currentStatus.setLastValue(new Date((Long)lastValue));
                }
                this.firstStatus = (Status)this.currentStatus.clone();
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        } else {
            try {
                Status currentStatus = new Status();
                currentStatus.setId(this.importContext.getStatusTableId());
                currentStatus.setTime(new Date().getTime());
                this.firstStatus = (Status)currentStatus.clone();
                this.currentStatus = currentStatus;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    protected void initStatusStore() {
        if (this.isIncreamentImport()) {
            this.statusTableName = this.importContext.getLastValueStoreTableName();
            if (this.statusTableName == null) {
                this.statusTableName = "increament_tab";
            }
            this.statusStorePath = this.importContext.getLastValueStorePath() == null || this.importContext.getLastValueStorePath().equals("") ? "StatusStoreDB" : this.importContext.getLastValueStorePath();
        }
    }

    protected void initDatasource() {
        if (this.isIncreamentImport()) {
            if (this.importContext.getStatusDbConfig() == null) {
                this.statusDbname = "_status_datasource";
                String dbJNDIName = "_status_datasource_jndi";
                try {
                    this.createStatusTableSQL = "create table " + this.statusTableName + " (ID number(10),lasttime number(10),lastvalue number(10),lastvaluetype number(1),PRIMARY KEY (ID))";
                    File dbpath = new File(this.statusStorePath);
                    this.logger.info("initDatasource dbpath:" + dbpath.getCanonicalPath());
                    SQLUtil.startPool((String)this.statusDbname, (String)"org.sqlite.JDBC", (String)("jdbc:sqlite://" + dbpath.getCanonicalPath()), (String)"root", (String)"root", null, null, (String)"select 1", (String)dbJNDIName, (int)10, (int)10, (int)20, (boolean)true, (boolean)false, null, (boolean)false, (boolean)false);
                }
                catch (Exception e) {
                    throw new ESDataImportException(e);
                }
            }
            DBConfig statusDBConfig = this.importContext.getStatusDbConfig();
            this.statusDbname = this.importContext.getStatusDbConfig().getDbName();
            if (this.statusDbname == null || this.statusDbname.trim().equals("")) {
                this.statusDbname = "_status_datasource";
            }
            if (statusDBConfig.getDbDriver() != null && !statusDBConfig.getDbDriver().trim().equals("")) {
                String dbJNDIName = this.statusDbname + "_jndi";
                try {
                    SQLUtil.startPool((String)this.statusDbname, (String)statusDBConfig.getDbDriver(), (String)statusDBConfig.getDbUrl(), (String)statusDBConfig.getDbUser(), (String)statusDBConfig.getDbPassword(), null, null, (String)statusDBConfig.getValidateSQL(), (String)dbJNDIName, (int)10, (int)10, (int)20, (boolean)true, (boolean)false, null, (boolean)false, (boolean)false);
                }
                catch (Exception e) {
                    throw new ESDataImportException(e);
                }
            }
            this.createStatusTableSQL = statusDBConfig.getStatusTableDML();
            if (this.createStatusTableSQL == null) {
                this.createStatusTableSQL = statusDBConfig.getCreateStatusTableSQL(SQLUtil.getPool((String)this.statusDbname).getDBType());
            }
            this.createStatusTableSQL = this.createStatusTableSQL.replace("$statusTableName", this.statusTableName);
            this.lastValueType = this.importContext.getDateLastValueColumn() != null ? 1 : (this.importContext.getNumberLastValueColumn() != null ? 0 : (this.importContext.getLastValueType() != null ? this.importContext.getLastValueType() : 0));
            this.importContext.setLastValueType(this.lastValueType);
            this.existSQL = "select 1 from " + this.statusTableName;
            this.selectSQL = "select id,lasttime,lastvalue,lastvaluetype from " + this.statusTableName + " where id=?";
            this.updateSQL = "update " + this.statusTableName + " set lasttime = ?,lastvalue = ? ,lastvaluetype= ? where id=?";
            this.insertSQL = "insert into " + this.statusTableName + " (id,lasttime,lastvalue,lastvaluetype) values(?,?,?,?)";
        }
    }

    public void setIncreamentImport(boolean increamentImport) {
        this.increamentImport = increamentImport;
    }

    public boolean isIncreamentImport() {
        return this.increamentImport;
    }

    @Override
    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushLastValue(Object lastValue) {
        if (lastValue != null) {
            long time = System.currentTimeMillis();
            Status status = this.currentStatus;
            synchronized (status) {
                this.currentStatus.setTime(time);
                this.currentStatus.setLastValue(lastValue);
            }
            if (this.isIncreamentImport()) {
                Status temp = new Status();
                temp.setTime(time);
                temp.setId(this.currentStatus.getId());
                temp.setLastValueType(this.currentStatus.getLastValueType());
                temp.setLastValue(lastValue);
                this.storeStatus(temp);
            }
        }
    }

    public void storeStatus(Status currentStatus) {
        try {
            this.updateStatus(currentStatus);
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    public void addStatus(Status currentStatus) throws Exception {
        Object lastValue = !this.importContext.isLastValueDateType() ? currentStatus.getLastValue() : Long.valueOf(((Date)currentStatus.getLastValue()).getTime());
        SQLExecutor.insertWithDBName((String)this.statusDbname, (String)this.insertSQL, (Object[])new Object[]{currentStatus.getId(), currentStatus.getTime(), lastValue, this.lastValueType});
    }

    public void updateStatus(Status currentStatus) throws Exception {
        Object lastValue = !this.importContext.isLastValueDateType() ? currentStatus.getLastValue() : Long.valueOf(((Date)currentStatus.getLastValue()).getTime());
        SQLExecutor.updateWithDBName((String)this.statusDbname, (String)this.updateSQL, (Object[])new Object[]{currentStatus.getTime(), lastValue, this.lastValueType, currentStatus.getId()});
    }

    @Override
    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    public TranErrorWrapper getErrorWrapper() {
        return this.errorWrapper;
    }

    @Override
    public void setErrorWrapper(TranErrorWrapper errorWrapper) {
        this.errorWrapper = errorWrapper;
    }

    @Override
    public void setForceStop() {
        this.forceStop = true;
    }

    @Override
    public boolean assertCondition() {
        if (this.forceStop) {
            return false;
        }
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition();
        }
        return true;
    }

    public boolean assertCondition(Exception e) {
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition(e);
        }
        return true;
    }

    protected void initES(String applicationPropertiesFile) {
        if (SimpleStringUtil.isNotEmpty((String)applicationPropertiesFile)) {
            ElasticSearchBoot.boot((String)applicationPropertiesFile);
        }
        if (this.importContext.getESConfig() != null) {
            ElasticSearchBoot.boot(this.importContext.getESConfig().getConfigs());
        }
    }

    public void initSchedule() {
        if (this.importContext.getScheduleConfig() != null) {
            this.scheduleService = new ScheduleService();
            this.scheduleService.init(this.importContext);
        }
    }

    protected void initDS(DBConfig dbConfig) {
        if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbUrl())) {
            SQLUtil.startPool((String)dbConfig.getDbName(), (String)dbConfig.getDbDriver(), (String)dbConfig.getDbUrl(), (String)dbConfig.getDbUser(), (String)dbConfig.getDbPassword(), null, null, (String)dbConfig.getValidateSQL(), (String)(dbConfig.getDbName() + "_jndi"), (int)dbConfig.getInitSize(), (int)dbConfig.getMinIdleSize(), (int)dbConfig.getMaxSize(), (boolean)dbConfig.isUsePool(), (boolean)false, null, (boolean)dbConfig.isShowSql(), (boolean)false, (int)(dbConfig.getJdbcFetchSize() == null ? 0 : dbConfig.getJdbcFetchSize()), (String)dbConfig.getDbtype(), (String)dbConfig.getDbAdaptor());
        }
    }

    protected void initOtherDSes(List<DBConfig> dbConfigs) {
        if (dbConfigs != null && dbConfigs.size() > 0) {
            for (DBConfig dbConfig : dbConfigs) {
                this.initDS(dbConfig);
            }
        }
    }

    protected void stopDS(DBConfig dbConfig) {
        block3: {
            if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbUrl())) {
                try {
                    SQLUtil.stopPool((String)dbConfig.getDbName());
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("SQLUtil.stopPool(" + dbConfig.getDbName() + ") failed:", (Throwable)e);
                }
            }
        }
    }

    protected void stopOtherDSES(List<DBConfig> dbConfigs) {
        if (dbConfigs != null && dbConfigs.size() > 0) {
            for (DBConfig dbConfig : dbConfigs) {
                this.stopDS(dbConfig);
            }
        }
    }
}

