/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.serial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.frameworkset.elasticsearch.entity.InnerSearchHit;
import org.frameworkset.elasticsearch.serial.BaseESHitDeserializer;
import org.frameworkset.elasticsearch.serial.ESClass;
import org.frameworkset.elasticsearch.serial.ESClassType;
import org.frameworkset.elasticsearch.serial.ESInnerHitSerialThreadLocal;
import org.frameworkset.elasticsearch.serial.ESSerialThreadLocal;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;

public class ESInnerHitDeserializer
extends BaseESHitDeserializer {
    @Override
    protected ESClass getESInnerTypeReferences() {
        return ESInnerHitSerialThreadLocal.getESInnerTypeReferences();
    }

    protected ESClass getESInnerTypeReferences(String type) {
        return ESInnerHitSerialThreadLocal.getESInnerTypeReferences(type);
    }

    private String getTypeName(JsonParser p) {
        return p.getParsingContext().getParent().getParent().getParent().getParent().getParent().getCurrentName();
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonStreamContext jsonStreamContext = p.getParsingContext().getParent();
        InnerSearchHit hit = (InnerSearchHit)jsonStreamContext.getCurrentValue();
        ESClass refs = null;
        if (hit != null) {
            refs = hit.getIndex() == null ? this.getESInnerTypeReferences(hit.getType()) : this.getESInnerTypeReferences(this.getTypeName(p));
        }
        if (refs == null) {
            return ctxt.findRootValueDeserializer(ESSerialThreadLocal.getMapObjectType()).deserialize(p, ctxt);
        }
        if (refs instanceof ESTypeReferences) {
            return ctxt.findRootValueDeserializer(ESSerialThreadLocal.getJavaType(((ESTypeReferences)refs).getHitType())).deserialize(p, ctxt);
        }
        ESClassType classType = (ESClassType)refs;
        return ctxt.findRootValueDeserializer(ESSerialThreadLocal.getJavaType(classType.getHitClass())).deserialize(p, ctxt);
    }
}

