/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.geoip;

import java.util.HashMap;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.entity.geo.GeoPoint;
import org.frameworkset.spi.geoip.GeoIPFilter;
import org.frameworkset.spi.geoip.GeoIPHandlerException;
import org.frameworkset.spi.geoip.IpInfo;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPUtil {
    private GeoIPFilter geoIPFilter;
    private String database;
    private String asnDatabase;
    private int cachesize;
    private String ipUrl;
    private static Logger logger = LoggerFactory.getLogger(GeoIPUtil.class);
    private static boolean getGeoIPUtil;
    private static GeoIPUtil geoIPUtil;

    public GeoIPFilter getGeoIPFilter() {
        return this.geoIPFilter;
    }

    public void init() {
        this.geoIPFilter = new GeoIPFilter(this.database, this.asnDatabase, this.cachesize);
    }

    public void setGeoIPFilter(GeoIPFilter geoIPFilter) {
        this.geoIPFilter = geoIPFilter;
    }

    public String getAsnDatabase() {
        return this.asnDatabase;
    }

    public void setAsnDatabase(String asnDatabase) {
        this.asnDatabase = asnDatabase;
    }

    public String getIpUrl() {
        return this.ipUrl;
    }

    public void setIpUrl(String ipUrl) {
        this.ipUrl = ipUrl;
    }

    public static void main(String[] args) {
        String ip = "localhost";
        String address = "";
        try {
            GeoIPUtil addressUtils = new GeoIPUtil();
            addressUtils.setIpUrl("http://ip.taobao.com/service/getIpInfo.php");
            address = addressUtils.getAddressResult("218.104.155.137");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(address);
    }

    public String getAddressResult(String ip) {
        StringBuilder url = new StringBuilder();
        url.append(this.ipUrl).append("?ip=").append(ip);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "text/html;charset=UTF-8");
        header.put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36");
        try {
            return HttpRequestUtil.httpGetforString((String)url.toString(), header);
        }
        catch (Exception e) {
            url.setLength(0);
            url.append("\u83b7\u53d6\u8fd0\u8425\u5546\u533a\u57df\u4fe1\u606f\u5f02\u5e38:").append(this.ipUrl).append("?ip=").append(ip).append(",User-Agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36").append(",Content-Type:text/html;charset=UTF-8");
            throw new GeoIPHandlerException("\u83b7\u53d6\u8fd0\u8425\u5546\u533a\u57df\u4fe1\u606f\u5f02\u5e38:" + url.toString(), e);
        }
    }

    public IpInfo getAddressMapResult(String ip) {
        Map<String, Object> geoData_ = this.geoIPFilter.handleIp(ip);
        if (geoData_ != null && geoData_.size() > 0) {
            Map<String, Object> asnData_ = this.geoIPFilter.handleIpAsn(ip);
            IpInfo ipInfo = new IpInfo();
            ipInfo.setIp(ip);
            ipInfo.setRegionId((String)geoData_.get("regionCode"));
            ipInfo.setArea("");
            ipInfo.setAreaId("");
            ipInfo.setCity((String)geoData_.get("cityName"));
            ipInfo.setCityId("");
            ipInfo.setCountry((String)geoData_.get("countryName"));
            ipInfo.setCountryId((String)geoData_.get("countryCode2"));
            ipInfo.setCounty((String)geoData_.get("regionName"));
            ipInfo.setCountyId((String)geoData_.get("regionCode"));
            ipInfo.setIsp((String)asnData_.get("asOrg"));
            ipInfo.setIspId((Integer)asnData_.get("asn"));
            ipInfo.setRegion((String)geoData_.get("regionName"));
            ipInfo.setRegionId((String)geoData_.get("regionCode"));
            Double latitude = (Double)geoData_.get("latitude");
            Double longitude = (Double)geoData_.get("longitude");
            GeoPoint geoPoint = new GeoPoint();
            geoPoint.setLat(latitude.doubleValue());
            geoPoint.setLon(longitude.doubleValue());
            ipInfo.setGeoPoint(geoPoint);
            return ipInfo;
        }
        IpInfo ipInfo = new IpInfo();
        ipInfo.setArea("");
        ipInfo.setAreaId("");
        ipInfo.setCity("\u672a\u77e5");
        ipInfo.setCityId("\u672a\u77e5");
        ipInfo.setCountry("\u672a\u77e5");
        ipInfo.setCountryId("\u672a\u77e5");
        ipInfo.setCounty("\u672a\u77e5");
        ipInfo.setCountyId("\u672a\u77e5");
        ipInfo.setIp(ip);
        ipInfo.setIsp("\u672a\u77e5");
        ipInfo.setIspId(null);
        ipInfo.setRegion("\u672a\u77e5");
        ipInfo.setRegionId("\u672a\u77e5");
        return ipInfo;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int getCachesize() {
        return this.cachesize;
    }

    public void setCachesize(int cachesize) {
        this.cachesize = cachesize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoIPUtil getGeoIPUtil() {
        if (getGeoIPUtil) {
            return geoIPUtil;
        }
        Class<GeoIPUtil> clazz = GeoIPUtil.class;
        synchronized (GeoIPUtil.class) {
            if (getGeoIPUtil) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return geoIPUtil;
            }
            getGeoIPUtil = true;
            if (geoIPUtil == null) {
                try {
                    Map geoipConfig = ElasticSearchHelper.getGeoipConfig();
                    GeoIPUtil geoIPUtil = new GeoIPUtil();
                    geoIPUtil.setDatabase((String)geoipConfig.get("ip.database"));
                    geoIPUtil.setAsnDatabase((String)geoipConfig.get("ip.asnDatabase"));
                    String _cachsize = (String)geoipConfig.get("ip.cachesize");
                    if (_cachsize != null) {
                        try {
                            geoIPUtil.setCachesize(Integer.parseInt(_cachsize));
                        }
                        catch (Exception e) {
                            logger.info("getGeoIPUtil ip.cachesize must be a number:" + _cachsize, (Throwable)e);
                        }
                    }
                    geoIPUtil.setIpUrl((String)geoipConfig.get("ip.serviceUrl"));
                    geoIPUtil.init();
                    GeoIPUtil.geoIPUtil = geoIPUtil;
                }
                catch (Exception e) {
                    logger.info("getGeoIPUtil failed:", (Throwable)e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return geoIPUtil;
        }
    }
}

