/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.context.InternalContextAdapterImpl;
import bboss.org.apache.velocity.exception.MethodInvocationException;
import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.exception.TemplateInitException;
import bboss.org.apache.velocity.exception.VelocityException;
import bboss.org.apache.velocity.runtime.directive.Scope;
import bboss.org.apache.velocity.runtime.directive.StopCommand;
import bboss.org.apache.velocity.runtime.parser.ParseException;
import bboss.org.apache.velocity.runtime.parser.node.SimpleNode;
import bboss.org.apache.velocity.runtime.resource.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;

public class Template
extends Resource {
    private String scopeName = "template";
    private boolean provideScope = false;
    private VelocityException errorCondition = null;

    public Template() {
        this.setType(1);
    }

    @Override
    public boolean process() throws ResourceNotFoundException, ParseErrorException {
        this.data = null;
        InputStream is = null;
        this.errorCondition = null;
        try {
            is = this.resourceLoader.getResourceStream(this.name);
        }
        catch (ResourceNotFoundException rnfe) {
            this.errorCondition = rnfe;
            throw rnfe;
        }
        if (is != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(is, this.encoding));
                this.data = this.rsvc.parse(br, this.name);
                this.initDocument();
                boolean bl = true;
                return bl;
            }
            catch (UnsupportedEncodingException uce) {
                String msg = "Template.process : Unsupported input encoding : " + this.encoding + " for template " + this.name;
                this.errorCondition = new ParseErrorException(msg);
                throw this.errorCondition;
            }
            catch (ParseException pex) {
                this.errorCondition = new ParseErrorException(pex, this.name);
                throw this.errorCondition;
            }
            catch (TemplateInitException pex) {
                this.errorCondition = new ParseErrorException(pex, this.name);
                throw this.errorCondition;
            }
            catch (RuntimeException e) {
                this.errorCondition = new VelocityException("Exception thrown processing Template " + this.getName(), e);
                throw this.errorCondition;
            }
            finally {
                block15: {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (this.errorCondition != null) break block15;
                        throw new VelocityException(e);
                    }
                }
            }
        }
        this.errorCondition = new ResourceNotFoundException("Unknown resource error for resource " + this.name);
        throw this.errorCondition;
    }

    public void initDocument() throws TemplateInitException {
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl(new VelocityContext());
        try {
            ica.pushCurrentTemplateName(this.name);
            ica.setCurrentResource(this);
            ((SimpleNode)this.data).init(ica, this.rsvc);
            String property = this.scopeName + '.' + "provide.scope.control";
            this.provideScope = this.rsvc.getBoolean(property, this.provideScope);
        }
        finally {
            ica.popCurrentTemplateName();
            ica.setCurrentResource(null);
        }
    }

    public void merge(Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        this.merge(context, writer, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void merge(Context context, Writer writer, List macroLibraries) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        if (this.errorCondition != null) {
            throw this.errorCondition;
        }
        if (this.data != null) {
            InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
            ica.setMacroLibraries(macroLibraries);
            if (macroLibraries != null) {
                for (int i = 0; i < macroLibraries.size(); ++i) {
                    try {
                        this.rsvc.getTemplate((String)macroLibraries.get(i));
                        continue;
                    }
                    catch (ResourceNotFoundException re) {
                        this.rsvc.getLog().error("template.merge(): cannot find template " + (String)macroLibraries.get(i));
                        throw re;
                    }
                    catch (ParseErrorException pe) {
                        this.rsvc.getLog().error("template.merge(): syntax error in template " + (String)macroLibraries.get(i) + ".");
                        throw pe;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Template.merge(): parse failed in template  " + (String)macroLibraries.get(i) + ".", e);
                    }
                }
            }
            if (this.provideScope) {
                ica.put(this.scopeName, new Scope(this, ica.get(this.scopeName)));
            }
            try {
                ica.pushCurrentTemplateName(this.name);
                ica.setCurrentResource(this);
                ((SimpleNode)this.data).render(ica, writer);
                return;
            }
            catch (StopCommand stop) {
                if (!stop.isFor(this)) {
                    throw stop;
                }
                if (!this.rsvc.getLog().isDebugEnabled()) return;
                this.rsvc.getLog().debug(stop.getMessage());
                return;
            }
            catch (IOException e) {
                throw new VelocityException("IO Error rendering template '" + this.name + "'", e);
            }
            finally {
                Object obj;
                ica.popCurrentTemplateName();
                ica.setCurrentResource(null);
                if (this.provideScope && (obj = ica.get(this.scopeName)) instanceof Scope) {
                    Scope scope = (Scope)obj;
                    if (scope.getParent() != null) {
                        ica.put(this.scopeName, scope.getParent());
                    } else if (scope.getReplaced() != null) {
                        ica.put(this.scopeName, scope.getReplaced());
                    } else {
                        ica.remove(this.scopeName);
                    }
                }
            }
        } else {
            String msg = "Template.merge() failure. The document is null, most likely due to parsing error.";
            throw new RuntimeException(msg);
        }
    }
}

