/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.cache;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class EdenConcurrentCache<K, V> {
    private final int size;
    public final int DEFAULT_SIZE = 1000;
    private final Map<K, V> eden;
    private Lock cacheLock = new ReentrantLock();
    private final Map<K, V> longterm;

    public EdenConcurrentCache() {
        this.size = 1000;
        this.eden = new ConcurrentHashMap();
        this.longterm = new WeakHashMap();
    }

    public EdenConcurrentCache(int size) {
        this.size = size;
        this.eden = new ConcurrentHashMap();
        this.longterm = new WeakHashMap();
    }

    public V get(K k) {
        V v = this.eden.get(k);
        if (v == null) {
            try {
                this.cacheLock.lock();
                v = this.longterm.get(k);
            }
            finally {
                this.cacheLock.unlock();
            }
            if (v != null) {
                this.eden.put(k, v);
            }
        }
        return v;
    }

    public int getMaxSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(K k, V v) {
        boolean outOfSize = false;
        if (this.eden.size() >= this.size) {
            try {
                this.cacheLock.lock();
                this.longterm.putAll(this.eden);
            }
            finally {
                this.cacheLock.unlock();
            }
            outOfSize = true;
            this.eden.clear();
        }
        this.eden.put(k, v);
        return outOfSize;
    }

    public int longtermSize() {
        return this.longterm.size();
    }

    public int edenSize() {
        return this.eden.size();
    }

    public void clear() {
        this.eden.clear();
        try {
            this.cacheLock.lock();
            this.longterm.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }
}

