/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.engine.model;

import com.frameworkset.orm.engine.EngineException;
import com.frameworkset.orm.engine.model.Database;
import com.frameworkset.orm.engine.model.NameGenerator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintNameGenerator
implements NameGenerator {
    private static Logger log = LoggerFactory.getLogger(ConstraintNameGenerator.class);

    @Override
    public String generateName(List inputs) throws EngineException {
        StringBuilder name = new StringBuilder();
        Database db = (Database)inputs.get(0);
        name.append((String)inputs.get(1));
        String namePostfix = (String)inputs.get(2);
        String constraintNbr = inputs.get(3).toString();
        int maxBodyLength = -1;
        try {
            int maxColumnNameLength = db.getPlatform().getMaxColumnNameLength();
            maxBodyLength = maxColumnNameLength - namePostfix.length() - constraintNbr.length() - 2;
            if (log.isDebugEnabled()) {
                log.debug("maxColumnNameLength=" + maxColumnNameLength + " maxBodyLength=" + maxBodyLength);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (maxBodyLength != -1 && name.length() > maxBodyLength) {
            name.setLength(maxBodyLength);
        }
        name.append('_').append(namePostfix).append('_').append(constraintNbr);
        return name.toString();
    }

    @Override
    public String generateName(List inputs, boolean IGNORE_FIRST_TOKEN) throws EngineException {
        StringBuilder name = new StringBuilder();
        Database db = (Database)inputs.get(0);
        name.append((String)inputs.get(1));
        String namePostfix = (String)inputs.get(2);
        String constraintNbr = inputs.get(3).toString();
        int maxBodyLength = -1;
        try {
            int maxColumnNameLength = db.getPlatform().getMaxColumnNameLength();
            maxBodyLength = maxColumnNameLength - namePostfix.length() - constraintNbr.length() - 2;
            if (log.isDebugEnabled()) {
                log.debug("maxColumnNameLength=" + maxColumnNameLength + " maxBodyLength=" + maxBodyLength);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (maxBodyLength != -1 && name.length() > maxBodyLength) {
            name.setLength(maxBodyLength);
        }
        name.append('_').append(namePostfix).append('_').append(constraintNbr);
        return name.toString();
    }
}

