/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2.managed;

import com.frameworkset.commons.dbcp2.managed.TransactionContextListener;
import com.frameworkset.commons.dbcp2.managed.TransactionRegistry;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;

public class TransactionContext {
    private final TransactionRegistry transactionRegistry;
    private final WeakReference<Transaction> transactionRef;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private Connection sharedConnection;
    private boolean transactionComplete;

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Objects.requireNonNull(transactionRegistry, "transactionRegistry is null");
        Objects.requireNonNull(transaction, "transaction is null");
        this.transactionRegistry = transactionRegistry;
        this.transactionRef = new WeakReference<Transaction>(transaction);
        this.transactionComplete = false;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction) {
        this(transactionRegistry, transaction, null);
    }

    public Connection getSharedConnection() {
        return this.sharedConnection;
    }

    public void setSharedConnection(Connection sharedConnection) throws SQLException {
        if (this.sharedConnection != null) {
            throw new IllegalStateException("A shared connection is already set");
        }
        Transaction transaction = this.getTransaction();
        try {
            XAResource xaResource = this.transactionRegistry.getXAResource(sharedConnection);
            if (!transaction.enlistResource(xaResource)) {
                throw new SQLException("Unable to enlist connection in transaction: enlistResource returns 'false'.");
            }
        }
        catch (IllegalStateException e) {
            throw new SQLException("Unable to enlist connection in the transaction", e);
        }
        catch (RollbackException e) {
        }
        catch (SystemException e) {
            throw new SQLException("Unable to enlist connection the transaction", e);
        }
        this.sharedConnection = sharedConnection;
    }

    public void addTransactionContextListener(final TransactionContextListener listener) throws SQLException {
        try {
            if (!this.isActive()) {
                Transaction transaction = (Transaction)this.transactionRef.get();
                listener.afterCompletion(this, transaction == null ? false : transaction.getStatus() == 3);
                return;
            }
            Synchronization s = new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    listener.afterCompletion(TransactionContext.this, status == 3);
                }
            };
            if (this.transactionSynchronizationRegistry != null) {
                this.transactionSynchronizationRegistry.registerInterposedSynchronization(s);
            } else {
                this.getTransaction().registerSynchronization(s);
            }
        }
        catch (RollbackException s) {
        }
        catch (Exception e) {
            throw new SQLException("Unable to register transaction context listener", e);
        }
    }

    public boolean isActive() throws SQLException {
        try {
            Transaction transaction = (Transaction)this.transactionRef.get();
            if (transaction == null) {
                return false;
            }
            int status = transaction.getStatus();
            return status == 0 || status == 1;
        }
        catch (SystemException e) {
            throw new SQLException("Unable to get transaction status", e);
        }
    }

    private Transaction getTransaction() throws SQLException {
        Transaction transaction = (Transaction)this.transactionRef.get();
        if (transaction == null) {
            throw new SQLException("Unable to enlist connection because the transaction has been garbage collected");
        }
        return transaction;
    }

    public void completeTransaction() {
        this.transactionComplete = true;
    }

    public boolean isTransactionComplete() {
        return this.transactionComplete;
    }
}

