/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.sql;

import com.frameworkset.common.poolman.sql.ColumnMetaData;
import com.frameworkset.common.poolman.sql.ForeignKeyMetaData;
import com.frameworkset.common.poolman.sql.PrimaryKeyMetaData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TableMetaData
implements Comparable,
Serializable {
    private String tableName;
    private String tableType;
    private String schema;
    private String remarks;
    private Set<ColumnMetaData> columns = new TreeSet<ColumnMetaData>();
    private Set<ColumnMetaData> primaryKeys = new TreeSet<ColumnMetaData>();
    private Set<ColumnMetaData> foreignKeys = new TreeSet<ColumnMetaData>();
    private Map<String, ColumnMetaData> columnsIdx = new HashMap<String, ColumnMetaData>();
    private Map<String, ColumnMetaData> primarysIdx = new HashMap<String, ColumnMetaData>();
    private Map<String, ColumnMetaData> foreignsIdx = new HashMap<String, ColumnMetaData>();

    public Set<ColumnMetaData> getColumns() {
        return this.columns;
    }

    public void addColumns(ColumnMetaData column) {
        this.columns.add(column);
        column.setTableMetaData(this);
        this.columnsIdx.put(column.getColumnName().toLowerCase(), column);
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public Set<ColumnMetaData> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void addPrimaryKey(ColumnMetaData column) {
        this.primaryKeys.add(column);
        column.setTableMetaData(this);
        this.primarysIdx.put(column.getColumnName().toLowerCase(), column);
    }

    public Set<ColumnMetaData> getForeignKeys() {
        return this.foreignKeys;
    }

    public void addForeignKey(ColumnMetaData foreignKey) {
        this.foreignKeys.add(foreignKey);
        foreignKey.setTableMetaData(this);
        this.foreignsIdx.put(foreignKey.getColumnName().toLowerCase(), foreignKey);
    }

    public ForeignKeyMetaData getForeignKeyMetaData(String columnName) {
        return (ForeignKeyMetaData)this.foreignsIdx.get(columnName.toLowerCase());
    }

    public PrimaryKeyMetaData getPrimaryKeyMetaData(String columnName) {
        return (PrimaryKeyMetaData)this.primarysIdx.get(columnName.toLowerCase());
    }

    public ColumnMetaData getColumnMetaData(String columnName) {
        return this.columnsIdx.get(columnName.toLowerCase());
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.tableName).append("(");
        Object[] objs = this.columns.toArray();
        boolean flag = false;
        ret.append("\r\n").append("\t\tColumns:");
        for (int i = 0; i < objs.length; ++i) {
            if (flag) {
                ret.append("\r\n").append(objs[i].toString());
                continue;
            }
            flag = true;
            ret.append("\r\n").append(objs[i].toString());
        }
        ret.append("\r\n").append("\t\tPrimaryKeys:");
        Object[] prks = this.primaryKeys.toArray();
        for (int i = 0; i < prks.length; ++i) {
            if (flag) {
                ret.append("\r\n").append(prks[i].toString());
                continue;
            }
            flag = true;
            ret.append("\r\n").append(prks[i].toString());
        }
        ret.append("\r\n").append("\t\tForeignKeys:");
        Object[] fks = this.foreignKeys.toArray();
        for (int i = 0; i < fks.length; ++i) {
            if (flag) {
                ret.append("\r\n").append(fks[i].toString());
                continue;
            }
            flag = true;
            ret.append("\r\n").append(fks[i].toString());
        }
        ret.append(")");
        return ret.toString();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public int hashCode() {
        return this.tableName.toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableMetaData) {
            TableMetaData temp = (TableMetaData)obj;
            if (temp != null) {
                return temp.getTableName().equalsIgnoreCase(this.tableName);
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof TableMetaData) {
            TableMetaData temp = (TableMetaData)obj;
            if (temp != null) {
                int ret = this.tableName.toLowerCase().compareTo(temp.getTableName().toLowerCase());
                return ret;
            }
            return 0;
        }
        return 0;
    }
}

