/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.sql.ColumnMetaData;
import com.frameworkset.common.poolman.sql.PrimaryKey;
import com.frameworkset.common.poolman.sql.PrimaryKeyCache;
import com.frameworkset.common.poolman.sql.PrimaryKeyCacheManager;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.orm.adapter.DB;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTableManager {
    private static Logger log = LoggerFactory.getLogger(BaseTableManager.class);
    public static final String queryTableInfoSql = "select * from tableinfo";
    public static final String queryTableInfoSqlBytableName = "select * from tableinfo where table_name=?";
    public static final String queryPrimaryKey = "select max(?) from ?";
    public static final String updateTableInfoSql = "update tableinfo set table_id_value=? where upper(table_name)=?";
    private static final Object token = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrimaryKeyCache getPoolTableInfos(String poolName) throws Exception {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs1 = null;
        Statement q_pstmt = null;
        Statement u_pstmt = null;
        ResultSet rs = null;
        HashMap<String, Object> trace = new HashMap<String, Object>();
        try {
            PrimaryKeyCache keyCache = new PrimaryKeyCache(poolName);
            con = SQLManager.getInstance().requestConnection(poolName);
            DB dbAdaptor = SQLManager.getInstance().getDBAdapter(poolName);
            JDBCPool pool = SQLManager.getInstance().getPool(poolName);
            log.info("load pool[" + poolName + "] tables information.......");
            stmt = con.createStatement(dbAdaptor.getSCROLLType(pool.getDriver()), dbAdaptor.getCusorType(pool.getDriver()));
            try {
                rs = stmt.executeQuery(queryTableInfoSql);
            }
            catch (Exception e1) {
                log.info("Ignore load table infomation !Check table [tableinfo] in your database! ");
                PrimaryKeyCache primaryKeyCache = null;
                trace.clear();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (rs1 != null) {
                        rs1.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (q_pstmt != null) {
                        q_pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (u_pstmt != null) {
                        u_pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return primaryKeyCache;
            }
            DB dbAdapter = SQLManager.getInstance().getDBAdapter(poolName);
            q_pstmt = con.createStatement(dbAdaptor.getSCROLLType(pool.getDriver()), dbAdaptor.getCusorType(pool.getDriver()));
            u_pstmt = con.prepareStatement(updateTableInfoSql, dbAdaptor.getSCROLLType(pool.getDriver()), dbAdaptor.getCusorType(pool.getDriver()));
            while (rs.next()) {
                ColumnMetaData cd;
                String table_name = rs.getString("table_name").trim();
                if (trace.containsKey(table_name.toLowerCase())) {
                    log.info("\u8b66\u544a\uff1atableinfo\u8868\u4e2d\u5b58\u5728\u591a\u6761\u3010" + table_name + "\u3011\u7684\u4e3b\u952e\u4fe1\u606f,\u53ea\u80fd\u4fdd\u6301\u4e00\u6761\u8bb0\u5f55\uff0c\u5426\u5219\u4f1a\u5f71\u54cd\u4e0e\u8be5\u8868\u76f8\u5173\u7684\u4e1a\u52a1\u7684\u5904\u7406.");
                } else {
                    trace.put(table_name.toLowerCase(), token);
                }
                log.info("    load table[" + table_name + "] information.......");
                String table_id_name = rs.getString("table_id_name").trim();
                int table_id_increment = rs.getInt("table_id_increment");
                long table_id_value = rs.getLong("table_id_value");
                String type = rs.getString("TABLE_ID_TYPE");
                String metaType = "int";
                if (type == null || type.equals("")) {
                    type = "int";
                }
                if (type.equals("sequence")) {
                    cd = DBUtil.getColumnMetaData(table_name, table_id_name, con);
                    if (cd != null) {
                        int type_ = cd.getDataType();
                        metaType = PrimaryKey.getJavaType(type_);
                    } else {
                        metaType = "int";
                    }
                } else if (type.equals("uuid")) {
                    cd = DBUtil.getColumnMetaData(table_name, table_id_name, con);
                    if (cd != null) {
                        int type_ = cd.getDataType();
                        metaType = PrimaryKey.getJavaType(type_);
                    } else {
                        metaType = "string";
                    }
                } else {
                    metaType = type;
                }
                String prefix = rs.getString("table_id_prefix");
                String TABLE_ID_GENERATOR = rs.getString("TABLE_ID_GENERATOR");
                if (prefix == null) {
                    prefix = "";
                }
                try {
                    String maxSql = dbAdapter.getIDMAXSql(table_name, table_id_name, prefix, metaType);
                    if (!type.equals("uuid") && !type.equals("sequence")) {
                        rs1 = q_pstmt.executeQuery(maxSql);
                        long new_table_id_value = 0L;
                        if (rs1.next()) {
                            new_table_id_value = rs1.getLong(1);
                        }
                        if (new_table_id_value > table_id_value || new_table_id_value < table_id_value) {
                            u_pstmt.setString(2, table_name.toUpperCase());
                            u_pstmt.setLong(1, new_table_id_value);
                            u_pstmt.execute();
                            table_id_value = new_table_id_value;
                        }
                    }
                    PrimaryKey primaryKey = new PrimaryKey(poolName, table_name.toLowerCase(), table_id_name.toLowerCase(), table_id_increment, table_id_value, type, prefix, maxSql, TABLE_ID_GENERATOR, con);
                    keyCache.addIDTable(primaryKey);
                }
                catch (Exception e) {
                    log.error("    load table[" + table_name + "] failed!\r\nerror message:\r\n" + e.getMessage(), (Throwable)e);
                }
            }
            PrimaryKeyCache primaryKeyCache = keyCache;
            return primaryKeyCache;
        }
        catch (Exception e) {
            log.info("Load table infomation failed! " + e.getMessage() + ". Please check table [tableinfo] in your database! ");
            PrimaryKeyCache primaryKeyCache = null;
            return primaryKeyCache;
        }
        finally {
            trace.clear();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs1 != null) {
                    rs1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (q_pstmt != null) {
                    q_pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (u_pstmt != null) {
                    u_pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static PrimaryKey getPoolTableInfo(String poolName, String tableName) throws Exception {
        return BaseTableManager.getPoolTableInfo(poolName, null, tableName);
    }

    /*
     * Exception decompiling
     */
    public static PrimaryKey getPoolTableInfo(String poolName, Connection con, String tableName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Nonsensical loop would be emitted - failure
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.considerAsDoLoopStart(LoopIdentifier.java:438)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.identifyLoops1(LoopIdentifier.java:65)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:681)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initTableInfo() throws Exception {
        log.debug("initial tableinfo start.......");
        List<String> poolNames = SQLManager.getInstance().getAllPoolNamesIfExist();
        for (int i = 0; i < poolNames.size(); ++i) {
            String poolName = poolNames.get(i);
            try {
                PrimaryKeyCache keyCache;
                String _poolname = SQLManager.getRealDBNameFromExternalDBName(poolName);
                if (PrimaryKeyCacheManager.getInstance().getPrimaryKeyCache(_poolname) != null || (keyCache = BaseTableManager.getPoolTableInfos(_poolname)) == null) continue;
                PrimaryKeyCacheManager.getInstance().addPrimaryKeyCache(keyCache);
                continue;
            }
            catch (Exception e) {
                log.info("load pool[" + poolName + "] tables information failed!\r\nerror message:\r\n", (Throwable)e);
            }
        }
        log.debug("initial tableinfo complete!");
    }

    public static void initTableInfo(String poolName) throws Exception {
        log.debug("initial tableinfo start for [" + poolName + "].......");
        try {
            PrimaryKeyCache keyCache;
            String _poolname = SQLManager.getRealDBNameFromExternalDBNameIfExist(poolName);
            if (PrimaryKeyCacheManager.getInstance().getPrimaryKeyCache(_poolname) == null && (keyCache = BaseTableManager.getPoolTableInfos(_poolname)) != null) {
                PrimaryKeyCacheManager.getInstance().addPrimaryKeyCache(keyCache);
            }
        }
        catch (Exception e) {
            log.error("load pool[" + poolName + "] tables information failed!\r\nerror message:\r\n" + e.getMessage(), (Throwable)e);
        }
        log.debug("initial tableinfo complete!");
    }

    public static void removePrimaryKeyCache(String poolname) {
        if (PrimaryKeyCacheManager.getInstance() != null) {
            PrimaryKeyCacheManager.getInstance().removePrimaryKeyCache(poolname);
        }
    }

    public static void updateTableInfo() {
    }
}

