/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.sswf;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.bazaarvoice.sswf.InputParser;
import com.bazaarvoice.sswf.Logger;
import com.bazaarvoice.sswf.WorkflowDefinition;
import com.bazaarvoice.sswf.service.StepActionWorker;
import com.bazaarvoice.sswf.service.StepDecisionWorker;
import com.bazaarvoice.sswf.service.WorkflowManagement;
import scala.reflect.ClassTag$;

public class Builders {

    public static class WorkflowManagementBuilder<SSWFInput, StepEnum extends Enum<StepEnum>> {
        private final Class<StepEnum> stepEnumClass;
        private String domain;
        private String taskList;
        private AmazonSimpleWorkflow swf;
        private InputParser<SSWFInput> inputParser;
        private String workflow;
        private String workflowVersion;
        private int workflowExecutionTimeoutSeconds = 2592000;
        private int workflowExecutionRetentionPeriodDays = 30;
        private int stepScheduleToStartTimeoutSeconds = 60;
        private Logger logger;

        public WorkflowManagementBuilder(Class<SSWFInput> clazz, Class<StepEnum> clazz2) {
            this.stepEnumClass = clazz2;
        }

        public WorkflowManagement<SSWFInput, StepEnum> build() {
            if (this.stepEnumClass == null) {
                throw new IllegalArgumentException("stepEnumClass was null");
            }
            if (this.domain == null) {
                throw new IllegalArgumentException("domain was null");
            }
            if (this.workflow == null) {
                throw new IllegalArgumentException("workflow was null");
            }
            if (this.workflowVersion == null) {
                throw new IllegalArgumentException("workflowVersion was null");
            }
            if (this.taskList == null) {
                throw new IllegalArgumentException("taskList was null");
            }
            if (this.swf == null) {
                throw new IllegalArgumentException("swf was null");
            }
            if (this.workflowExecutionTimeoutSeconds <= 0) {
                throw new IllegalArgumentException("workflowExecutionTimeoutSeconds must be set > 0");
            }
            if (this.workflowExecutionRetentionPeriodDays <= 0) {
                throw new IllegalArgumentException("workflowExecutionRetentionPeriodDays must be set > 0");
            }
            if (this.stepScheduleToStartTimeoutSeconds <= 0) {
                throw new IllegalArgumentException("stepScheduleToStartTimeoutSeconds must be set > 0");
            }
            if (this.inputParser == null) {
                throw new IllegalArgumentException("inputParser was null");
            }
            if (this.logger == null) {
                throw new IllegalArgumentException("logger was null");
            }
            return new WorkflowManagement(this.domain, this.workflow, this.workflowVersion, this.taskList, this.swf, this.workflowExecutionTimeoutSeconds, this.workflowExecutionRetentionPeriodDays, this.stepScheduleToStartTimeoutSeconds, this.inputParser, this.logger, ClassTag$.MODULE$.apply(this.stepEnumClass));
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setDomain(String string) {
            this.domain = string;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setTaskList(String string) {
            this.taskList = string;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setSwf(AmazonSimpleWorkflow amazonSimpleWorkflow) {
            this.swf = amazonSimpleWorkflow;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setInputParser(InputParser<SSWFInput> inputParser) {
            this.inputParser = inputParser;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setWorkflow(String string) {
            this.workflow = string;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setWorkflowVersion(String string) {
            this.workflowVersion = string;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setWorkflowExecutionTimeoutSeconds(int n) {
            this.workflowExecutionTimeoutSeconds = n;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setWorkflowExecutionRetentionPeriodDays(int n) {
            this.workflowExecutionRetentionPeriodDays = n;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setStepScheduleToStartTimeoutSeconds(int n) {
            this.stepScheduleToStartTimeoutSeconds = n;
            return this;
        }

        public WorkflowManagementBuilder<SSWFInput, StepEnum> setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }
    }

    public static class StepDecisionWorkerBuilder<SSWFInput, StepEnum extends Enum<StepEnum>> {
        private final Class<StepEnum> stepEnumClass;
        private String domain;
        private String taskList;
        private AmazonSimpleWorkflow swf;
        private InputParser<SSWFInput> inputParser;
        private WorkflowDefinition<SSWFInput, StepEnum> workflowDefinition;
        private Logger logger;

        public StepDecisionWorkerBuilder(Class<SSWFInput> clazz, Class<StepEnum> clazz2) {
            this.stepEnumClass = clazz2;
        }

        public StepDecisionWorker<SSWFInput, StepEnum> build() {
            if (this.stepEnumClass == null) {
                throw new IllegalArgumentException("stepEnumClass was null");
            }
            if (this.domain == null) {
                throw new IllegalArgumentException("domain was null");
            }
            if (this.taskList == null) {
                throw new IllegalArgumentException("taskList was null");
            }
            if (this.swf == null) {
                throw new IllegalArgumentException("swf was null");
            }
            if (this.inputParser == null) {
                throw new IllegalArgumentException("inputParser was null");
            }
            if (this.workflowDefinition == null) {
                throw new IllegalArgumentException("workflowDefinition was null");
            }
            if (this.logger == null) {
                throw new IllegalArgumentException("logger was null");
            }
            return new StepDecisionWorker<SSWFInput, StepEnum>(this.domain, this.taskList, this.swf, this.inputParser, this.workflowDefinition, this.logger, ClassTag$.MODULE$.apply(this.stepEnumClass));
        }

        public StepDecisionWorkerBuilder<SSWFInput, StepEnum> setDomain(String string) {
            this.domain = string;
            return this;
        }

        public StepDecisionWorkerBuilder<SSWFInput, StepEnum> setTaskList(String string) {
            this.taskList = string;
            return this;
        }

        public StepDecisionWorkerBuilder<SSWFInput, StepEnum> setSwf(AmazonSimpleWorkflow amazonSimpleWorkflow) {
            this.swf = amazonSimpleWorkflow;
            return this;
        }

        public StepDecisionWorkerBuilder<SSWFInput, StepEnum> setInputParser(InputParser<SSWFInput> inputParser) {
            this.inputParser = inputParser;
            return this;
        }

        public StepDecisionWorkerBuilder<SSWFInput, StepEnum> setWorkflowDefinition(WorkflowDefinition<SSWFInput, StepEnum> workflowDefinition) {
            this.workflowDefinition = workflowDefinition;
            return this;
        }

        public StepDecisionWorkerBuilder<SSWFInput, StepEnum> setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }
    }

    public static class StepActionWorkerBuilder<SSWFInput, StepEnum extends Enum<StepEnum>> {
        private final Class<StepEnum> stepEnumClass;
        private String domain;
        private String taskList;
        private AmazonSimpleWorkflow swf;
        private InputParser<SSWFInput> inputParser;
        private WorkflowDefinition<SSWFInput, StepEnum> workflowDefinition;
        private Logger logger;

        public StepActionWorkerBuilder(Class<SSWFInput> clazz, Class<StepEnum> clazz2) {
            this.stepEnumClass = clazz2;
        }

        public StepActionWorker<SSWFInput, StepEnum> build() {
            if (this.stepEnumClass == null) {
                throw new IllegalArgumentException("stepEnumClass was null");
            }
            if (this.domain == null) {
                throw new IllegalArgumentException("domain was null");
            }
            if (this.taskList == null) {
                throw new IllegalArgumentException("taskList was null");
            }
            if (this.swf == null) {
                throw new IllegalArgumentException("swf was null");
            }
            if (this.inputParser == null) {
                throw new IllegalArgumentException("inputParser was null");
            }
            if (this.workflowDefinition == null) {
                throw new IllegalArgumentException("workflowDefinition was null");
            }
            if (this.logger == null) {
                throw new IllegalArgumentException("logger was null");
            }
            return new StepActionWorker<SSWFInput, StepEnum>(this.domain, this.taskList, this.swf, this.inputParser, this.workflowDefinition, this.logger, ClassTag$.MODULE$.apply(this.stepEnumClass));
        }

        public StepActionWorkerBuilder<SSWFInput, StepEnum> setDomain(String string) {
            this.domain = string;
            return this;
        }

        public StepActionWorkerBuilder<SSWFInput, StepEnum> setTaskList(String string) {
            this.taskList = string;
            return this;
        }

        public StepActionWorkerBuilder<SSWFInput, StepEnum> setSwf(AmazonSimpleWorkflow amazonSimpleWorkflow) {
            this.swf = amazonSimpleWorkflow;
            return this;
        }

        public StepActionWorkerBuilder<SSWFInput, StepEnum> setInputParser(InputParser<SSWFInput> inputParser) {
            this.inputParser = inputParser;
            return this;
        }

        public StepActionWorkerBuilder<SSWFInput, StepEnum> setWorkflowDefinition(WorkflowDefinition<SSWFInput, StepEnum> workflowDefinition) {
            this.workflowDefinition = workflowDefinition;
            return this;
        }

        public StepActionWorkerBuilder<SSWFInput, StepEnum> setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }
    }
}

