/*
 * Decompiled with CFR 0.152.
 */
package example;

import com.amazonaws.AbortedException;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfo;
import com.bazaarvoice.sswf.Builders;
import com.bazaarvoice.sswf.Logger;
import com.bazaarvoice.sswf.model.DefinedStep;
import com.bazaarvoice.sswf.model.history.StepEvent;
import com.bazaarvoice.sswf.model.history.StepsHistory;
import com.bazaarvoice.sswf.service.StepActionWorker;
import com.bazaarvoice.sswf.service.StepDecisionWorker;
import com.bazaarvoice.sswf.service.WorkflowManagement;
import example.ExampleSignalHandler;
import example.ExampleWorkflowDefinition;
import example.ExampleWorkflowInput;
import example.ExampleWorkflowSteps;
import example.StdOutLogger;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ExampleWorkflowService {
    final AmazonSimpleWorkflow swf = new AmazonSimpleWorkflowClient();
    final String domain = "java-sswf-example";
    final String workflow = "example-java-workflow";
    final String workflowVersion = "0.4";
    final String taskList = "my-machine";
    final Logger logger = new StdOutLogger();
    final ExampleWorkflowInput.Parser inputParser = new ExampleWorkflowInput.Parser();
    final WorkflowManagement<ExampleWorkflowInput, ExampleWorkflowSteps> workflowManagement = new Builders.WorkflowManagementBuilder<ExampleWorkflowInput, ExampleWorkflowSteps>(ExampleWorkflowInput.class, ExampleWorkflowSteps.class).setDomain("java-sswf-example").setWorkflow("example-java-workflow").setWorkflowVersion("0.4").setTaskList("my-machine").setSwf(this.swf).setWorkflowExecutionTimeoutSeconds(2592000).setWorkflowExecutionRetentionPeriodDays(30).setStepScheduleToStartTimeoutSeconds(30).setInputParser(this.inputParser).setLogger(this.logger).build();
    final ExampleSignalHandler signalHandler = new ExampleSignalHandler(this.workflowManagement);
    final ExampleWorkflowDefinition workflowDefinition = new ExampleWorkflowDefinition(this.workflowManagement, this.signalHandler);
    final StepDecisionWorker<ExampleWorkflowInput, ExampleWorkflowSteps> decisionWorker = new Builders.StepDecisionWorkerBuilder<ExampleWorkflowInput, ExampleWorkflowSteps>(ExampleWorkflowInput.class, ExampleWorkflowSteps.class).setDomain("java-sswf-example").setTaskList("my-machine").setSwf(this.swf).setInputParser(this.inputParser).setWorkflowDefinition(this.workflowDefinition).setLogger(this.logger).build();
    final StepActionWorker<ExampleWorkflowInput, ExampleWorkflowSteps> actionWorker = new Builders.StepActionWorkerBuilder<ExampleWorkflowInput, ExampleWorkflowSteps>(ExampleWorkflowInput.class, ExampleWorkflowSteps.class).setDomain("java-sswf-example").setTaskList("my-machine").setSwf(this.swf).setInputParser(this.inputParser).setWorkflowDefinition(this.workflowDefinition).setLogger(this.logger).build();
    final ScheduledExecutorService decisionExecutor = Executors.newSingleThreadScheduledExecutor();
    final ScheduledExecutorService actionExecutor = Executors.newScheduledThreadPool(3);
    final ExecutorService actionWorkers = Executors.newCachedThreadPool();

    public void start() {
        this.workflowManagement.registerWorkflow();
        this.signalHandler.start();
        this.decisionExecutor.scheduleAtFixedRate(() -> {
            try {
                System.out.println("Decision: polling for work");
                DecisionTask decisionTask = this.decisionWorker.pollForDecisionsToMake();
                while (decisionTask != null) {
                    System.out.println("Decision: got task for " + decisionTask.getWorkflowExecution());
                    RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest = this.decisionWorker.makeDecision(decisionTask);
                    System.out.println("Decision: made decision " + (respondDecisionTaskCompletedRequest == null ? "null" : respondDecisionTaskCompletedRequest.getDecisions()));
                    decisionTask = this.decisionWorker.pollForDecisionsToMake();
                }
                System.out.println("Decision: Got no task...");
                System.out.println("Decision: done");
            }
            catch (AbortedException abortedException) {
                System.out.println("Decision thread shutting down.");
            }
            catch (Throwable throwable) {
                System.err.println("Decision: unexpected exception. Continuing...");
                throwable.printStackTrace(System.err);
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        this.actionExecutor.scheduleAtFixedRate(() -> {
            try {
                System.out.println("Action: polling for work");
                ActivityTask activityTask = this.actionWorker.pollForWork();
                while (activityTask != null) {
                    ActivityTask activityTask2 = activityTask;
                    this.actionWorkers.submit(() -> {
                        try {
                            System.out.println("Action: got task for " + activityTask2.getWorkflowExecution());
                            RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest = this.actionWorker.doWork(activityTask2);
                            System.out.println("Action: complete for " + activityTask2.getWorkflowExecution() + ": " + (respondActivityTaskCompletedRequest == null ? "null" : respondActivityTaskCompletedRequest.getResult()));
                        }
                        catch (Throwable throwable) {
                            System.err.println("Action: unexpected exception executing work.");
                            throwable.printStackTrace(System.err);
                            throw throwable;
                        }
                    });
                    activityTask = this.actionWorker.pollForWork();
                }
                System.out.println("Action: Got no task...");
                System.out.println("Action: done");
            }
            catch (AbortedException abortedException) {
                System.out.println("Action poller thread shutting down.");
            }
            catch (Throwable throwable) {
                System.err.println("Action: unexpected exception polling/submitting. Continuing...");
                throwable.printStackTrace(System.err);
            }
        }, 15L, 5L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.decisionExecutor.shutdownNow();
        this.actionExecutor.shutdownNow();
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws InterruptedException {
        List<WorkflowExecutionInfo> list;
        Date date = new Date();
        ExampleWorkflowService exampleWorkflowService = new ExampleWorkflowService();
        exampleWorkflowService.start();
        ExampleWorkflowService.startWorkflowForFunAndProfit(exampleWorkflowService);
        ExampleWorkflowService.startWorkflowForFunAndProfit(exampleWorkflowService);
        ExampleWorkflowService.startWorkflowForFunAndProfit(exampleWorkflowService);
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            Thread.sleep(5000L);
            list = exampleWorkflowService.workflowManagement.listExecutions(new Date(System.currentTimeMillis() - 86400000L), new Date());
            int n = 0;
            for (WorkflowExecutionInfo object : list) {
                void var10_13;
                if (!Objects.equals(object.getExecutionStatus(), "OPEN")) continue;
                ++n;
                StepsHistory<ExampleWorkflowInput, ExampleWorkflowSteps> stepsHistory = exampleWorkflowService.workflowManagement.describeExecution(object.getExecution().getWorkflowId(), object.getExecution().getRunId());
                System.out.println("");
                System.out.println("WF history: " + object.getExecution());
                System.out.println("  input: " + stepsHistory.input());
                System.out.println("  firedTimers: " + stepsHistory.firedTimers());
                System.out.println("  events:");
                Object var10_14 = null;
                for (StepEvent<ExampleWorkflowSteps> stepEvent : stepsHistory.events()) {
                    System.out.println("    " + stepEvent);
                    StepEvent<ExampleWorkflowSteps> stepEvent2 = stepEvent;
                }
                System.out.println();
                if (var10_13 != null && !bl && var10_13.event().isLeft() && var10_13.event().left().get() instanceof DefinedStep && ((DefinedStep)var10_13.event().left().get()).step() == ExampleWorkflowSteps.EXTRACT_STEP && Objects.equals(var10_13.result(), "STARTED")) {
                    System.out.println("Cancelling workflow!");
                    exampleWorkflowService.workflowManagement.cancelWorkflowExecution(object.getExecution().getWorkflowId(), object.getExecution().getRunId());
                    bl = true;
                }
                if (var10_13 == null || bl2 || !var10_13.event().isLeft() || !(var10_13.event().left().get() instanceof DefinedStep) || ((DefinedStep)var10_13.event().left().get()).step() == ExampleWorkflowSteps.EXTRACT_STEP) continue;
                System.out.println("Cancelling workflow!");
                exampleWorkflowService.workflowManagement.cancelWorkflowExecution(object.getExecution().getWorkflowId(), object.getExecution().getRunId());
                bl2 = true;
            }
            if (n == 0) break;
            System.out.println(n + " workflows are still open.");
        }
        System.out.println("all workflows are done!");
        list = exampleWorkflowService.workflowManagement.listExecutions(date, new Date());
        System.out.println("\nExecutions this run:");
        for (WorkflowExecutionInfo workflowExecutionInfo : list) {
            StepsHistory<ExampleWorkflowInput, ExampleWorkflowSteps> stepsHistory = exampleWorkflowService.workflowManagement.describeExecution(workflowExecutionInfo.getExecution().getWorkflowId(), workflowExecutionInfo.getExecution().getRunId());
            System.out.println("");
            System.out.println("WF history: " + workflowExecutionInfo.getExecution());
            System.out.println("  input: " + stepsHistory.input());
            System.out.println("  firedTimers: " + stepsHistory.firedTimers());
            System.out.println("  events:");
            for (StepEvent stepEvent : stepsHistory.events()) {
                System.out.println("    " + stepEvent);
            }
            System.out.println();
        }
        System.out.println("shutting down...");
        exampleWorkflowService.stop();
    }

    private static void startWorkflowForFunAndProfit(ExampleWorkflowService exampleWorkflowService) {
        int n = new Random().nextInt(Integer.MAX_VALUE);
        ExampleWorkflowInput exampleWorkflowInput = new ExampleWorkflowInput("example-input-parameter-value-" + n);
        WorkflowExecution workflowExecution = exampleWorkflowService.workflowManagement.startWorkflow("workflow-" + n, exampleWorkflowInput);
        System.out.println("started " + workflowExecution);
    }
}

