/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.sswf.service;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.model.CompleteWorkflowExecutionDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.Decision;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.DecisionType;
import com.amazonaws.services.simpleworkflow.model.FailWorkflowExecutionDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.ScheduleActivityTaskDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.StartTimerDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.bazaarvoice.sswf.InputParser;
import com.bazaarvoice.sswf.Logger;
import com.bazaarvoice.sswf.WorkflowDefinition;
import com.bazaarvoice.sswf.WorkflowStep;
import com.bazaarvoice.sswf.model.ScheduledStep;
import com.bazaarvoice.sswf.model.StepInput;
import com.bazaarvoice.sswf.model.history.HistoryFactory$;
import com.bazaarvoice.sswf.model.history.StepEvent;
import com.bazaarvoice.sswf.model.history.StepsHistory;
import com.bazaarvoice.sswf.model.result.Cancelled;
import com.bazaarvoice.sswf.model.result.Failed;
import com.bazaarvoice.sswf.model.result.InProgress;
import com.bazaarvoice.sswf.model.result.StepResult;
import com.bazaarvoice.sswf.model.result.StepResult$;
import com.bazaarvoice.sswf.model.result.Success;
import com.bazaarvoice.sswf.model.result.TimedOut;
import com.bazaarvoice.sswf.service.util$;
import com.bazaarvoice.sswf.util.package$;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001-\u0011!c\u0015;fa\u0012+7-[:j_:<vN]6fe*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!\u0001\u0003tg^4'BA\u0004\t\u0003-\u0011\u0017M_1beZ|\u0017nY3\u000b\u0003%\t1aY8n\u0007\u0001)2\u0001\u0004\u001aB'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\t)\u0001\u0011\t\u0011)A\u0005+\u00051Am\\7bS:\u0004\"AF\r\u000f\u000599\u0012B\u0001\r\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011!d\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ay\u0001\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002\u0011Q\f7o\u001b'jgRD\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0004g^4\u0007CA\u0011)\u001b\u0005\u0011#BA\u0012%\u00039\u0019\u0018.\u001c9mK^|'o\u001b4m_^T!!\n\u0014\u0002\u0011M,'O^5dKNT!a\n\u0005\u0002\u0013\u0005l\u0017M_8oC^\u001c\u0018BA\u0015#\u0005Q\tU.\u0019>p]NKW\u000e\u001d7f/>\u00148N\u001a7po\"A1\u0006\u0001B\u0001B\u0003%A&A\u0006j]B,H\u000fU1sg\u0016\u0014\bcA\u0017/a5\tA!\u0003\u00020\t\tY\u0011J\u001c9viB\u000b'o]3s!\t\t$\u0007\u0004\u0001\u0005\u000bM\u0002!\u0019\u0001\u001b\u0003\u0013M\u001bvKR%oaV$\u0018CA\u001b9!\tqa'\u0003\u00028\u001f\t9aj\u001c;iS:<\u0007C\u0001\b:\u0013\tQtBA\u0002B]fD\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!P\u0001\u0013o>\u00148N\u001a7po\u0012+g-\u001b8ji&|g\u000e\u0005\u0003.}A\u0002\u0015BA \u0005\u0005I9vN]6gY><H)\u001a4j]&$\u0018n\u001c8\u0011\u0005E\nE!\u0002\"\u0001\u0005\u0004\u0019%\u0001C*uKB,e.^7\u0012\u0005U\"%cA#H\u001f\u001a!a\t\u0001\u0001E\u00051a$/\u001a4j]\u0016lWM\u001c;?!\rAU\nQ\u0007\u0002\u0013*\u0011!jS\u0001\u0005Y\u0006twMC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%\u0001B#ok6\u0004\"!\f)\n\u0005E#!\u0001D,pe.4Gn\\<Ti\u0016\u0004\b\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\u0002\u00071|w\r\u0005\u0002.+&\u0011a\u000b\u0002\u0002\u0007\u0019><w-\u001a:\t\u0011a\u0003!1!Q\u0001\fe\u000b!\"\u001a<jI\u0016t7-\u001a\u00132!\rQV\fQ\u0007\u00027*\u0011AlD\u0001\be\u00164G.Z2u\u0013\tq6L\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003\u0019a\u0014N\\5u}Q9!MZ4iS*\\GCA2f!\u0011!\u0007\u0001\r!\u000e\u0003\tAQ\u0001W0A\u0004eCQ\u0001F0A\u0002UAQ!H0A\u0002UAQaH0A\u0002\u0001BQaK0A\u00021BQ\u0001P0A\u0002uBQaU0A\u0002QCa!\u001c\u0001!\u0002\u0013q\u0017\u0001C5eK:$\u0018\u000e^=\u0011\u0005!{\u0017B\u0001\u000eJ\u0011\u0015\t\b\u0001\"\u0001s\u0003Y\u0001x\u000e\u001c7G_J$UmY5tS>t7\u000fV8NC.,G#A:\u0011\u0005Q<X\"A;\u000b\u0005Y\u0014\u0013!B7pI\u0016d\u0017B\u0001=v\u00051!UmY5tS>tG+Y:lQ\t\u0001(\u0010E\u0002|\u0003\u000bi\u0011\u0001 \u0006\u0003{z\f\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0004\u007f\u0006\u0005\u0011AB5ti\u0006\u001c7NC\u0002\u0002\u0004!\t1a];o\u0013\r\t9\u0001 \u0002\t\u001dVdG.\u00192mK\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0011\u0001D7bW\u0016$UmY5tS>tG\u0003BA\b\u0003+\u00012\u0001^A\t\u0013\r\t\u0019\"\u001e\u0002$%\u0016\u001c\bo\u001c8e\t\u0016\u001c\u0017n]5p]R\u000b7o[\"p[BdW\r^3e%\u0016\fX/Z:u\u0011\u001d\t9\"!\u0003A\u0002M\fA\u0002Z3dSNLwN\u001c+bg.DC!!\u0006\u0002\u001cA\u001910!\b\n\u0007\u0005}APA\u0004O_RtU\u000f\u001c7\t\u0011\u0005\r\u0002\u0001)C\u0005\u0003K\t\u0011#\u001b8oKJl\u0015m[3EK\u000eL7/[8o)\u0019\ty!a\n\u0002*!9\u0011qCA\u0011\u0001\u0004\u0019\b\u0002CA\u0016\u0003C\u0001\r!!\f\u0002\r\u00154XM\u001c;t!\u0019\ty#a\u0010\u0002F9!\u0011\u0011GA\u001e\u001d\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c\u0015\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u0003{y\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0003MSN$(bAA\u001f\u001fA\u0019A/a\u0012\n\u0007\u0005%SO\u0001\u0007ISN$xN]=Fm\u0016tG\u000f\u0003\u0005\u0002N\u0001\u0001K\u0011BA(\u000399W\r\u001e$vY2D\u0015n\u001d;pef$B!!\u0015\u0002XA1a\"a\u0015t\u0003[I1!!\u0016\u0010\u0005\u0019!V\u000f\u001d7fe!9\u0011qCA&\u0001\u0004\u0019\b\u0002CA.\u0001\u0001&I!!\u0018\u0002\u0013]\f\u0017\u000e\u001e*fiJLH\u0003BA0\u0003K\u00022\u0001^A1\u0013\r\t\u0019'\u001e\u0002\t\t\u0016\u001c\u0017n]5p]\"A\u0011qMA-\u0001\u0004\tI'A\u0003sKR\u0014\u0018\u0010E\u0003\u0002l\u0005=\u0004)\u0004\u0002\u0002n)\u0011a\u000fB\u0005\u0005\u0003c\niGA\u0007TG\",G-\u001e7fIN#X\r\u001d")
public class StepDecisionWorker<SSWFInput, StepEnum extends Enum<StepEnum>> {
    private final String domain;
    private final String taskList;
    private final AmazonSimpleWorkflow swf;
    private final InputParser<SSWFInput> inputParser;
    private final WorkflowDefinition<SSWFInput, StepEnum> workflowDefinition;
    private final Logger log;
    private final ClassTag<StepEnum> evidence$1;
    private final String identity;

    @Nullable
    public DecisionTask pollForDecisionsToMake() {
        DecisionTask decisionTask = this.swf.pollForDecisionTask(new PollForDecisionTaskRequest().withDomain(this.domain).withTaskList(new TaskList().withName(this.taskList)).withIdentity(this.identity));
        return decisionTask.getTaskToken() == null ? null : decisionTask;
    }

    public RespondDecisionTaskCompletedRequest makeDecision(@NotNull DecisionTask decisionTask) {
        Predef$.MODULE$.require(decisionTask != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "decisionTask must not be null";
            }
        });
        this.log.debug((Function0<String>)new Serializable(this, decisionTask){
            public static final long serialVersionUID = 0L;
            private final DecisionTask decisionTask$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting makeDecision for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decisionTask$1.getStartedEventId()}));
            }
            {
                this.decisionTask$1 = decisionTask$1;
            }
        });
        Tuple2<DecisionTask, List<HistoryEvent>> tuple2 = this.getFullHistory(decisionTask);
        if (tuple2 != null) {
            Tuple2 tuple22;
            DecisionTask newDecisionTask = (DecisionTask)tuple2._1();
            List events = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)newDecisionTask, (Object)events);
            DecisionTask newDecisionTask2 = (DecisionTask)tuple23._1();
            List events2 = (List)tuple23._2();
            this.log.debug((Function0<String>)new Serializable(this, decisionTask){
                public static final long serialVersionUID = 0L;
                private final DecisionTask decisionTask$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"get history for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decisionTask$1.getStartedEventId()}));
                }
                {
                    this.decisionTask$1 = decisionTask$1;
                }
            });
            RespondDecisionTaskCompletedRequest completedRequest = this.innerMakeDecision(newDecisionTask2, (List<HistoryEvent>)events2);
            this.log.debug((Function0<String>)new Serializable(this, decisionTask){
                public static final long serialVersionUID = 0L;
                private final DecisionTask decisionTask$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"made decision for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decisionTask$1.getStartedEventId()}));
                }
                {
                    this.decisionTask$1 = decisionTask$1;
                }
            });
            this.swf.respondDecisionTaskCompleted(completedRequest);
            return completedRequest;
        }
        throw new MatchError(tuple2);
    }

    private RespondDecisionTaskCompletedRequest innerMakeDecision(DecisionTask decisionTask, List<HistoryEvent> events) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest;
            Object object = new Object();
            try {
                this.log.debug((Function0<String>)new Serializable(this, decisionTask){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTask decisionTask$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting innerMakeDecision for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decisionTask$2.getStartedEventId()}));
                    }
                    {
                        this.decisionTask$2 = decisionTask$2;
                    }
                });
                StepsHistory<SSWFInput, StepEnum> history = HistoryFactory$.MODULE$.from(events, this.inputParser, this.evidence$1);
                this.log.debug((Function0<String>)new Serializable(this, decisionTask){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTask decisionTask$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"got history for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decisionTask$2.getStartedEventId()}));
                    }
                    {
                        this.decisionTask$2 = decisionTask$2;
                    }
                });
                SSWFInput input = history.input();
                this.log.debug((Function0<String>)new Serializable(this, decisionTask){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTask decisionTask$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checking for fired timers for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decisionTask$2.getStartedEventId()}));
                    }
                    {
                        this.decisionTask$2 = decisionTask$2;
                    }
                });
                if (JavaConversions$.MODULE$.asScalaSet(history.firedTimers()).nonEmpty()) {
                    return this.com$bazaarvoice$sswf$service$StepDecisionWorker$$respond$1(this.com$bazaarvoice$sswf$service$StepDecisionWorker$$schedule$1((Option)new Some(JavaConversions$.MODULE$.asScalaSet(history.firedTimers()).head()), decisionTask, history, input), decisionTask);
                }
                this.log.debug((Function0<String>)new Serializable(this, decisionTask){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTask decisionTask$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"finding final states for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decisionTask$2.getStartedEventId()}));
                    }
                    {
                        this.decisionTask$2 = decisionTask$2;
                    }
                });
                Buffer finalStates = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                JavaConversions$.MODULE$.asScalaBuffer(history.events()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StepEvent<StepEnum> e) {
                        return e.event().isLeft();
                    }
                }).foreach((Function1)new Serializable(this, finalStates){
                    public static final long serialVersionUID = 0L;
                    private final Buffer finalStates$1;

                    public final void apply(StepEvent<StepEnum> e) {
                        StepResult result = StepResult$.MODULE$.deserialize(e.result());
                        if (this.finalStates$1.isEmpty()) {
                            this.finalStates$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepEvent[]{e}));
                        } else {
                            ScheduledStep<StepEnum> scheduledStep = ((ScheduledStep)((StepEvent)this.finalStates$1.last()).event().left().get()).withoutResume();
                            ScheduledStep<StepEnum> scheduledStep2 = ((ScheduledStep)e.event().left().get()).withoutResume();
                            if (!(scheduledStep != null ? !((Object)scheduledStep).equals(scheduledStep2) : scheduledStep2 != null)) {
                                this.finalStates$1.remove(this.finalStates$1.length() - 1);
                                this.finalStates$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepEvent[]{e}));
                            } else {
                                this.finalStates$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StepEvent[]{e}));
                            }
                        }
                    }
                    {
                        this.finalStates$1 = finalStates$1;
                    }
                });
                this.log.debug((Function0<String>)new Serializable(this, decisionTask){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTask decisionTask$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"determining next step for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.decisionTask$2.getStartedEventId()}));
                    }
                    {
                        this.decisionTask$2 = decisionTask$2;
                    }
                });
                Iterator fsIt = finalStates.iterator();
                JavaConversions$.MODULE$.asScalaBuffer(this.workflowDefinition.workflow(input)).foreach((Function1)new Serializable(this, decisionTask, history, input, fsIt, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ StepDecisionWorker $outer;
                    private final DecisionTask decisionTask$2;
                    private final StepsHistory history$1;
                    private final Object input$1;
                    private final Iterator fsIt$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(ScheduledStep<StepEnum> step) {
                        if (this.fsIt$1.hasNext()) {
                            StepResult result;
                            StepEvent thisFS = (StepEvent)this.fsIt$1.next();
                            ScheduledStep<StepEnum> scheduledStep = ((ScheduledStep)thisFS.event().left().get()).withoutResume();
                            ScheduledStep<StepEnum> scheduledStep2 = step;
                            Predef$.MODULE$.assert(!(scheduledStep != null ? !((Object)scheduledStep).equals(scheduledStep2) : scheduledStep2 != null), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final StepEvent thisFS$1;
                                private final ScheduledStep step$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did the workflow change? [", "] != [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.thisFS$1.event().left().get(), this.step$1}));
                                }
                                {
                                    this.thisFS$1 = thisFS$1;
                                    this.step$1 = step$1;
                                }
                            });
                            StepResult stepResult = result = StepResult$.MODULE$.deserialize(thisFS.result());
                            if (stepResult instanceof Failed) {
                                Failed failed = (Failed)stepResult;
                                Option<String> m = failed.message();
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$respond$1(this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$fail$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed stage ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{step})), new Failed(m).toString(), this.decisionTask$2, this.history$1, this.input$1), this.decisionTask$2));
                            }
                            if (stepResult instanceof Cancelled) {
                                Cancelled cancelled = (Cancelled)stepResult;
                                Option<String> m = cancelled.message();
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$respond$1(this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$fail$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cancelled stage ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{step})), new Cancelled(m).toString(), this.decisionTask$2, this.history$1, this.input$1), this.decisionTask$2));
                            }
                            if (stepResult instanceof InProgress) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$respond$1(this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$waitRetry(step), this.decisionTask$2));
                            }
                            if (stepResult instanceof TimedOut) {
                                TimedOut timedOut = (TimedOut)stepResult;
                                String timeoutType = timedOut.timeoutType();
                                Option<String> resumeInfo = timedOut.resumeInfo();
                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"got: ").append((Object)new TimedOut(timeoutType, resumeInfo)).toString());
                                Option<String> x$3 = resumeInfo;
                                Option<String> x$4 = step.stepInput().copy$default$1();
                                StepInput x$5 = step.stepInput().copy(x$4, x$3);
                                StepEnum x$6 = step.copy$default$1();
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$respond$1(this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$resume$1(step.copy(x$6, x$5), this.input$1), this.decisionTask$2));
                            }
                            if (stepResult instanceof Success) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)stepResult);
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$respond$1(this.$outer.com$bazaarvoice$sswf$service$StepDecisionWorker$$schedule$1((Option)new Some(step), this.decisionTask$2, this.history$1, this.input$1), this.decisionTask$2));
                    }
                    {
                        void var6_6;
                        void var5_5;
                        void var4_4;
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.decisionTask$2 = decisionTask$2;
                        this.history$1 = var3_3;
                        this.input$1 = var4_4;
                        this.fsIt$1 = var5_5;
                        this.nonLocalReturnKey1$1 = var6_6;
                    }
                });
                respondDecisionTaskCompletedRequest = this.com$bazaarvoice$sswf$service$StepDecisionWorker$$respond$1(this.com$bazaarvoice$sswf$service$StepDecisionWorker$$schedule$1((Option)None$.MODULE$, decisionTask, history, input), decisionTask);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                respondDecisionTaskCompletedRequest = (RespondDecisionTaskCompletedRequest)nonLocalReturnControl2.value();
            }
            return respondDecisionTaskCompletedRequest;
        }
        throw nonLocalReturnControl2;
    }

    private Tuple2<DecisionTask, List<HistoryEvent>> getFullHistory(DecisionTask decisionTask) {
        List events = JavaConversions$.MODULE$.asScalaBuffer(decisionTask.getEvents()).toList();
        DecisionTask newDecisionTask = decisionTask;
        while (newDecisionTask.getNextPageToken() != null) {
            List list;
            DecisionTask decisionTask2;
            decisionTask2 = this.swf.pollForDecisionTask(new PollForDecisionTaskRequest().withDomain(this.domain).withTaskList(new TaskList().withName(this.taskList)).withIdentity(this.identity).withNextPageToken(decisionTask2.getNextPageToken()));
            void var4_4 = list;
            list = JavaConversions$.MODULE$.asScalaBuffer(decisionTask2.getEvents()).toList().$colon$colon$colon((List)var4_4);
        }
        return new Tuple2((Object)newDecisionTask, (Object)events);
    }

    public Decision com$bazaarvoice$sswf$service$StepDecisionWorker$$waitRetry(ScheduledStep<StepEnum> retry) {
        return new Decision().withDecisionType(DecisionType.StartTimer).withStartTimerDecisionAttributes(new StartTimerDecisionAttributes().withTimerId(UUID.randomUUID().toString()).withControl(package$.MODULE$.packTimer(((Enum)retry.step()).name(), retry.stepInput())).withStartToFireTimeout(((Object)BoxesRunTime.boxToInteger((int)((WorkflowStep)retry.step()).inProgressTimerSeconds())).toString()));
    }

    public final RespondDecisionTaskCompletedRequest com$bazaarvoice$sswf$service$StepDecisionWorker$$respond$1(Decision d, DecisionTask decisionTask$2) {
        return new RespondDecisionTaskCompletedRequest().withDecisions((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Decision[]{d})))).withTaskToken(decisionTask$2.getTaskToken());
    }

    public final Decision com$bazaarvoice$sswf$service$StepDecisionWorker$$resume$1(ScheduledStep step, Object input$1) {
        ScheduleActivityTaskDecisionAttributes scheduleActivityTaskDecisionAttributes = new ScheduleActivityTaskDecisionAttributes().withActivityId(((Enum)step.step()).name()).withActivityType(new ActivityType().withName(((Enum)step.step()).name()).withVersion(util$.MODULE$.stepToVersion(step.step()))).withTaskList(new TaskList().withName(this.taskList)).withInput(package$.MODULE$.packInput(this.inputParser, step.stepInput(), input$1));
        return new Decision().withDecisionType(DecisionType.ScheduleActivityTask).withScheduleActivityTaskDecisionAttributes(scheduleActivityTaskDecisionAttributes);
    }

    public final Decision com$bazaarvoice$sswf$service$StepDecisionWorker$$schedule$1(Option activity, DecisionTask decisionTask$2, StepsHistory history$1, Object input$1) {
        Option option;
        block4: {
            Decision decision;
            block3: {
                block2: {
                    option = activity;
                    if (!None$.MODULE$.equals(option)) break block2;
                    String message = "No more activities to schedule.";
                    this.workflowDefinition.onFinish(decisionTask$2.getWorkflowExecution().getWorkflowId(), decisionTask$2.getWorkflowExecution().getRunId(), input$1, history$1, message);
                    CompleteWorkflowExecutionDecisionAttributes attributes = new CompleteWorkflowExecutionDecisionAttributes();
                    attributes = attributes.withResult(message);
                    decision = new Decision().withDecisionType(DecisionType.CompleteWorkflowExecution).withCompleteWorkflowExecutionDecisionAttributes(attributes);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                ScheduledStep step = (ScheduledStep)some.x();
                ScheduleActivityTaskDecisionAttributes scheduleActivityTaskDecisionAttributes = new ScheduleActivityTaskDecisionAttributes().withActivityId(((Enum)step.step()).name()).withActivityType(new ActivityType().withName(((Enum)step.step()).name()).withVersion(util$.MODULE$.stepToVersion(step.step()))).withTaskList(new TaskList().withName(this.taskList)).withInput(package$.MODULE$.packInput(this.inputParser, step.stepInput(), input$1));
                decision = new Decision().withDecisionType(DecisionType.ScheduleActivityTask).withScheduleActivityTaskDecisionAttributes(scheduleActivityTaskDecisionAttributes);
            }
            return decision;
        }
        throw new MatchError((Object)option);
    }

    public final Decision com$bazaarvoice$sswf$service$StepDecisionWorker$$fail$1(String shortDescription, String message, DecisionTask decisionTask$2, StepsHistory history$1, Object input$1) {
        Predef$.MODULE$.require(shortDescription.length() < 256);
        String fullMessage = new StringBuilder().append((Object)shortDescription).append((Object)": ").append((Object)message).toString();
        this.workflowDefinition.onFail(decisionTask$2.getWorkflowExecution().getWorkflowId(), decisionTask$2.getWorkflowExecution().getRunId(), input$1, history$1, fullMessage);
        FailWorkflowExecutionDecisionAttributes attributes = new FailWorkflowExecutionDecisionAttributes().withReason(shortDescription).withDetails(fullMessage);
        return new Decision().withDecisionType(DecisionType.FailWorkflowExecution).withFailWorkflowExecutionDecisionAttributes(attributes);
    }

    public StepDecisionWorker(String domain, String taskList, AmazonSimpleWorkflow swf, InputParser<SSWFInput> inputParser, WorkflowDefinition<SSWFInput, StepEnum> workflowDefinition, Logger log, ClassTag<StepEnum> evidence$1) {
        this.domain = domain;
        this.taskList = taskList;
        this.swf = swf;
        this.inputParser = inputParser;
        this.workflowDefinition = workflowDefinition;
        this.log = log;
        this.evidence$1 = evidence$1;
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
    }
}

