/*
 * Decompiled with CFR 0.152.
 */
package example;

import com.bazaarvoice.sswf.HeartbeatCallback;
import com.bazaarvoice.sswf.WorkflowDefinition;
import com.bazaarvoice.sswf.model.ScheduledStep;
import com.bazaarvoice.sswf.model.history.StepsHistory;
import com.bazaarvoice.sswf.model.result.InProgress;
import com.bazaarvoice.sswf.model.result.StepResult;
import com.bazaarvoice.sswf.model.result.Success;
import example.ExampleWorkflowInput;
import example.ExampleWorkflowSteps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import scala.Option;
import scala.Some;

public class ExampleWorkflowDefinition
implements WorkflowDefinition<ExampleWorkflowInput, ExampleWorkflowSteps> {
    private static Map<String, String> state = new ConcurrentHashMap<String, String>();

    @Override
    public List<ScheduledStep<ExampleWorkflowSteps>> workflow(ExampleWorkflowInput exampleWorkflowInput) {
        return Arrays.asList(new ScheduledStep<ExampleWorkflowSteps>(ExampleWorkflowSteps.EXTRACT_STEP), new ScheduledStep<ExampleWorkflowSteps>(ExampleWorkflowSteps.TRANSFORM_STEP, (Option<String>)new Some((Object)"format1->format2")), new ScheduledStep<ExampleWorkflowSteps>(ExampleWorkflowSteps.TRANSFORM_STEP, (Option<String>)new Some((Object)"format2->format3")), new ScheduledStep<ExampleWorkflowSteps>(ExampleWorkflowSteps.LOAD_STEP));
    }

    @Override
    public void onFail(String string, String string2, ExampleWorkflowInput exampleWorkflowInput, StepsHistory<ExampleWorkflowInput, ExampleWorkflowSteps> stepsHistory, String string3) {
        System.out.println("[" + string + "/" + string2 + "] Workflow(" + exampleWorkflowInput.getName() + ") Failed!!! " + string3);
    }

    @Override
    public void onFinish(String string, String string2, ExampleWorkflowInput exampleWorkflowInput, StepsHistory<ExampleWorkflowInput, ExampleWorkflowSteps> stepsHistory, String string3) {
        System.out.println("[" + string + "/" + string2 + "] Workflow(" + exampleWorkflowInput.getName() + ") Finished!!! " + string3);
    }

    @Override
    public StepResult act(ExampleWorkflowSteps exampleWorkflowSteps, ExampleWorkflowInput exampleWorkflowInput, Option<String> option, HeartbeatCallback heartbeatCallback) {
        switch (exampleWorkflowSteps) {
            case EXTRACT_STEP: {
                boolean bl = heartbeatCallback.checkIn("just an example heartbeat checkin");
                System.out.println("Cancellation requested: " + bl);
                if (!Objects.equals(state.get(exampleWorkflowInput.getName()), "extract finished")) {
                    state.put(exampleWorkflowInput.getName(), "extract finished");
                    return new InProgress("started extract");
                }
                return new Success("Extract is done.");
            }
            case TRANSFORM_STEP: {
                if (!Objects.equals(state.get(exampleWorkflowInput.getName()), "transform finished (" + option + ")")) {
                    state.put(exampleWorkflowInput.getName(), "transform finished (" + option + ")");
                    return new InProgress("transform started (" + option + ")");
                }
                return new Success("Nothing to do!");
            }
            case LOAD_STEP: {
                if (!Objects.equals(state.get(exampleWorkflowInput.getName()), "load finished")) {
                    state.put(exampleWorkflowInput.getName(), "load finished");
                    return new InProgress("load started");
                }
                return new Success("load finished");
            }
        }
        throw new IllegalStateException("Unexpected step enum" + exampleWorkflowSteps);
    }
}

