/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.spec;

import com.bazaarvoice.jolt.common.spec.BaseSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class SpecBuilder<T extends BaseSpec> {
    public List<T> createSpec(Map<String, Object> rawSpec) {
        ArrayList<T> result = new ArrayList<T>();
        HashSet<String> actualKeys = new HashSet<String>();
        for (String rawLhsStr : rawSpec.keySet()) {
            String[] keyStrings;
            Object rawRhs = rawSpec.get(rawLhsStr);
            for (String keyString : keyStrings = rawLhsStr.split("\\|")) {
                T childSpec = this.createSpec(keyString, rawRhs);
                String childCanonicalString = childSpec.getPathElement().getCanonicalForm();
                if (actualKeys.contains(childCanonicalString)) {
                    throw new IllegalArgumentException("Duplicate canonical key found : " + childCanonicalString);
                }
                actualKeys.add(childCanonicalString);
                result.add(childSpec);
            }
        }
        return result;
    }

    public abstract T createSpec(String var1, Object var2);
}

