/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier;

import com.bazaarvoice.jolt.exception.SpecException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum OpMode {
    OVERWRITR("+"){

        @Override
        public boolean isApplicable(Map source, String key) {
            return super.isApplicable(source, key);
        }

        @Override
        public boolean isApplicable(List source, int reqIndex, int origSize) {
            return super.isApplicable(source, reqIndex, origSize);
        }
    }
    ,
    DEFAULTR("~"){

        @Override
        public boolean isApplicable(Map source, String key) {
            return super.isApplicable(source, key) && source.get(key) == null;
        }

        @Override
        public boolean isApplicable(List source, int reqIndex, int origSize) {
            return super.isApplicable(source, reqIndex, origSize) && source.get(reqIndex) == null;
        }
    }
    ,
    DEFINER("_"){

        @Override
        public boolean isApplicable(Map source, String key) {
            return super.isApplicable(source, key) && !source.containsKey(key);
        }

        @Override
        public boolean isApplicable(List source, int reqIndex, int origSize) {
            return super.isApplicable(source, reqIndex, origSize) && reqIndex >= origSize && source.get(reqIndex) == null;
        }
    };

    private String op;
    private static Map<String, OpMode> opModeMap;

    private OpMode(String op) {
        this.op = op;
    }

    public String getOp() {
        return this.op;
    }

    public String toString() {
        return this.op + "modify";
    }

    public boolean isApplicable(Map source, String key) {
        return source != null && key != null;
    }

    public boolean isApplicable(List source, int reqIndex, int origSize) {
        return source != null && reqIndex >= 0 && origSize >= 0;
    }

    public static boolean isValid(String op) {
        return opModeMap.containsKey(op);
    }

    public static OpMode from(String op) {
        if (OpMode.isValid(op)) {
            return opModeMap.get(op);
        }
        throw new SpecException("OpMode " + op + " is not valid");
    }

    static {
        opModeMap = new HashMap<String, OpMode>();
        opModeMap.put(OpMode.OVERWRITR.op, OVERWRITR);
        opModeMap.put(OpMode.DEFAULTR.op, DEFAULTR);
        opModeMap.put(OpMode.DEFINER.op, DEFINER);
    }
}

