/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.traversr;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.traversr.TraversrException;
import com.bazaarvoice.jolt.traversr.traversal.ArrayTraversalStep;
import com.bazaarvoice.jolt.traversr.traversal.AutoExpandArrayTraversalStep;
import com.bazaarvoice.jolt.traversr.traversal.MapTraversalStep;
import com.bazaarvoice.jolt.traversr.traversal.TraversalStep;
import java.util.List;

public abstract class Traversr<DataType> {
    private final TraversalStep root;
    private final int traversalLength;

    public Traversr(String humanPath) {
        String intermediatePath = humanPath.replace("[", ".[");
        intermediatePath = intermediatePath.replace("..", ".");
        if (intermediatePath.charAt(0) == '.') {
            intermediatePath = intermediatePath.substring(1);
        }
        String[] paths = intermediatePath.split("\\.");
        TraversalStep rooty = null;
        for (int index = paths.length - 1; index >= 0; --index) {
            rooty = this.makePathElement(paths[index], rooty);
        }
        this.traversalLength = paths.length;
        this.root = rooty;
    }

    public Traversr(List<String> paths) {
        TraversalStep rooty = null;
        for (int index = paths.size() - 1; index >= 0; --index) {
            rooty = this.makePathElement(paths.get(index), rooty);
        }
        this.traversalLength = paths.size();
        this.root = rooty;
    }

    private TraversalStep makePathElement(String path, TraversalStep child) {
        if ("[]".equals(path)) {
            return new AutoExpandArrayTraversalStep(this, child);
        }
        if (path.startsWith("[") && path.endsWith("]")) {
            return new ArrayTraversalStep(this, child);
        }
        return new MapTraversalStep(this, child);
    }

    public Optional<DataType> get(Object tree, List<String> keys) {
        if (keys.size() != this.traversalLength) {
            throw new TraversrException("Traversal Path and number of keys mismatch, traversalLength:" + this.traversalLength + " numKeys:" + keys.size());
        }
        return this.root.traverse(tree, TraversalStep.Operation.GET, keys.iterator(), null);
    }

    public Optional<DataType> set(Object tree, List<String> keys, DataType data) {
        if (keys.size() != this.traversalLength) {
            throw new TraversrException("Traversal Path and number of keys mismatch, traversalLength:" + this.traversalLength + " numKeys:" + keys.size());
        }
        if (tree == null) {
            return Optional.empty();
        }
        return this.root.traverse(tree, TraversalStep.Operation.SET, keys.iterator(), data);
    }

    public Optional<DataType> remove(Object tree, List<String> keys) {
        if (keys.size() != this.traversalLength) {
            throw new TraversrException("Traversal Path and number of keys mismatch, traversalLength:" + this.traversalLength + " numKeys:" + keys.size());
        }
        if (tree == null) {
            return Optional.empty();
        }
        return this.root.traverse(tree, TraversalStep.Operation.REMOVE, keys.iterator(), null);
    }

    public abstract Optional<DataType> handleFinalSet(TraversalStep var1, Object var2, String var3, DataType var4);

    public abstract Optional<DataType> handleIntermediateGet(TraversalStep var1, Object var2, String var3, TraversalStep.Operation var4);
}

