/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.function;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.modifier.function.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Objects {
    public static Optional<? extends Number> toNumber(Object arg) {
        if (arg instanceof Number) {
            return Optional.of((Number)arg);
        }
        if (arg instanceof String) {
            try {
                return Optional.of(Integer.parseInt((String)arg));
            }
            catch (Exception exception) {
                try {
                    return Optional.of(Long.parseLong((String)arg));
                }
                catch (Exception exception2) {
                    try {
                        return Optional.of(Double.parseDouble((String)arg));
                    }
                    catch (Exception exception3) {
                        return Optional.empty();
                    }
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<Integer> toInteger(Object arg) {
        if (arg instanceof Number) {
            return Optional.of(((Number)arg).intValue());
        }
        if (arg instanceof String) {
            Optional<? extends Number> optional = Objects.toNumber(arg);
            if (optional.isPresent()) {
                return Optional.of(optional.get().intValue());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<Long> toLong(Object arg) {
        if (arg instanceof Number) {
            return Optional.of(((Number)arg).longValue());
        }
        if (arg instanceof String) {
            Optional<? extends Number> optional = Objects.toNumber(arg);
            if (optional.isPresent()) {
                return Optional.of(optional.get().longValue());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<Double> toDouble(Object arg) {
        if (arg instanceof Number) {
            return Optional.of(((Number)arg).doubleValue());
        }
        if (arg instanceof String) {
            Optional<? extends Number> optional = Objects.toNumber(arg);
            if (optional.isPresent()) {
                return Optional.of(optional.get().doubleValue());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<Boolean> toBoolean(Object arg) {
        if (arg instanceof Boolean) {
            return Optional.of((Boolean)arg);
        }
        if (arg instanceof String) {
            if ("true".equalsIgnoreCase((String)arg)) {
                return Optional.of(Boolean.TRUE);
            }
            if ("false".equalsIgnoreCase((String)arg)) {
                return Optional.of(Boolean.FALSE);
            }
        }
        return Optional.empty();
    }

    public static Optional<String> toString(Object arg) {
        if (arg instanceof String) {
            return Optional.of((String)arg);
        }
        if (arg instanceof Object[]) {
            return Optional.of(Arrays.toString((Object[])arg));
        }
        return Optional.of(java.util.Objects.toString(arg));
    }

    public static void squashNulls(Object input) {
        if (input instanceof List) {
            List inputList = (List)input;
            inputList.removeIf(java.util.Objects::isNull);
        } else if (input instanceof Map) {
            Map inputMap = (Map)input;
            ArrayList keysToNuke = new ArrayList();
            for (Map.Entry entry : inputMap.entrySet()) {
                if (entry.getValue() != null) continue;
                keysToNuke.add(entry.getKey());
            }
            inputMap.keySet().removeAll(keysToNuke);
        }
    }

    public static void recursivelySquashNulls(Object input) {
        Objects.squashNulls(input);
        if (input instanceof List) {
            List inputList = (List)input;
            inputList.forEach(i -> Objects.recursivelySquashNulls(i));
        } else if (input instanceof Map) {
            Map inputMap = (Map)input;
            for (Map.Entry entry : inputMap.entrySet()) {
                Objects.recursivelySquashNulls(entry.getValue());
            }
        }
    }

    public static final class size
    implements Function {
        @Override
        public Optional<Object> apply(Object ... args) {
            if (args.length == 0) {
                return Optional.empty();
            }
            if (args.length == 1) {
                if (args[0] == null) {
                    return Optional.empty();
                }
                if (args[0] instanceof List) {
                    return Optional.of(((List)args[0]).size());
                }
                if (args[0] instanceof String) {
                    return Optional.of(((String)args[0]).length());
                }
                if (args[0] instanceof Map) {
                    return Optional.of(((Map)args[0]).size());
                }
                return Optional.empty();
            }
            return Optional.of(args.length);
        }
    }

    public static final class recursivelySquashNulls
    extends Function.SingleFunction<Object> {
        @Override
        protected Optional<Object> applySingle(Object arg) {
            Objects.recursivelySquashNulls(arg);
            return Optional.of(arg);
        }
    }

    public static final class squashNulls
    extends Function.SingleFunction<Object> {
        @Override
        protected Optional<Object> applySingle(Object arg) {
            Objects.squashNulls(arg);
            return Optional.of(arg);
        }
    }

    public static final class toString
    extends Function.SingleFunction<String> {
        @Override
        protected Optional<String> applySingle(Object arg) {
            return Objects.toString(arg);
        }
    }

    public static final class toBoolean
    extends Function.SingleFunction<Boolean> {
        @Override
        protected Optional<Boolean> applySingle(Object arg) {
            return Objects.toBoolean(arg);
        }
    }

    public static final class toDouble
    extends Function.SingleFunction<Double> {
        @Override
        protected Optional<Double> applySingle(Object arg) {
            return Objects.toDouble(arg);
        }
    }

    public static final class toLong
    extends Function.SingleFunction<Long> {
        @Override
        protected Optional<Long> applySingle(Object arg) {
            return Objects.toLong(arg);
        }
    }

    public static final class toInteger
    extends Function.SingleFunction<Integer> {
        @Override
        protected Optional<Integer> applySingle(Object arg) {
            return Objects.toInteger(arg);
        }
    }
}

