/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.function;

import com.bazaarvoice.jolt.common.Optional;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public interface Function {
    public static final Function noop = new Function(){

        @Override
        public Optional<Object> apply(Object ... args) {
            return Optional.empty();
        }
    };
    public static final Function isPresent = new Function(){

        @Override
        public Optional<Object> apply(Object ... args) {
            if (args.length == 0) {
                return Optional.empty();
            }
            return Optional.of(args[0]);
        }
    };
    public static final Function notNull = new Function(){

        @Override
        public Optional<Object> apply(Object ... args) {
            if (args.length == 0 || args[0] == null) {
                return Optional.empty();
            }
            return Optional.of(args[0]);
        }
    };
    public static final Function isNull = new Function(){

        @Override
        public Optional<Object> apply(Object ... args) {
            if (args.length == 0 || args[0] != null) {
                return Optional.empty();
            }
            return Optional.of(args[0]);
        }
    };

    public Optional<Object> apply(Object ... var1);

    public static abstract class ArgDrivenListFunction<S>
    extends ArgDrivenFunction<S, Object> {
        @Override
        protected abstract Optional<Object> applyList(S var1, List<Object> var2);

        @Override
        protected final Optional<Object> applySingle(S specialArg, Object arg) {
            return Optional.empty();
        }
    }

    public static abstract class ArgDrivenSingleFunction<S, R>
    extends ArgDrivenFunction<S, R> {
        @Override
        protected final Optional<Object> applyList(S specialArg, List<Object> input) {
            ArrayList<Object> ret = new ArrayList<Object>(input.size());
            for (Object o : input) {
                Optional<R> optional = this.applySingle(specialArg, o);
                ret.add(optional.isPresent() ? optional.get() : o);
            }
            return Optional.of(ret);
        }

        @Override
        protected abstract Optional<R> applySingle(S var1, Object var2);
    }

    public static abstract class ArgDrivenFunction<SOURCE, RETTYPE>
    implements Function {
        private final Class<SOURCE> specialArgType;

        private ArgDrivenFunction() {
            Type superclass = this.getClass().getGenericSuperclass();
            this.specialArgType = superclass instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)superclass).getActualTypeArguments()[0] : Object.class;
        }

        private Optional<SOURCE> getSpecialArg(Object[] args) {
            if (args.length >= 2 && this.specialArgType.isInstance(args[0])) {
                Object specialArg = args[0];
                return Optional.of(specialArg);
            }
            return Optional.empty();
        }

        @Override
        public final Optional<Object> apply(Object ... args) {
            Optional<SOURCE> specialArgOptional;
            if (args.length == 1 && args[0] instanceof List) {
                args = ((List)args[0]).toArray();
            }
            if ((specialArgOptional = this.getSpecialArg(args)).isPresent()) {
                SOURCE specialArg = specialArgOptional.get();
                if (args.length == 2) {
                    if (args[1] instanceof List) {
                        return this.applyList(specialArg, (List)args[1]);
                    }
                    return this.applySingle(specialArg, args[1]);
                }
                List<Object> input = Arrays.asList(Arrays.copyOfRange(args, 1, args.length));
                return this.applyList(specialArg, input);
            }
            return Optional.empty();
        }

        protected abstract Optional<Object> applyList(SOURCE var1, List<Object> var2);

        protected abstract Optional<RETTYPE> applySingle(SOURCE var1, Object var2);
    }

    public static abstract class ListFunction
    extends BaseFunction<Object> {
        @Override
        protected abstract Optional<Object> applyList(List<Object> var1);

        @Override
        protected final Optional<Object> applySingle(Object arg) {
            return Optional.empty();
        }
    }

    public static abstract class SingleFunction<T>
    extends BaseFunction<T> {
        @Override
        protected final Optional<Object> applyList(List<Object> input) {
            ArrayList<Object> ret = new ArrayList<Object>(input.size());
            for (Object o : input) {
                Optional<T> optional = this.applySingle(o);
                ret.add(optional.isPresent() ? optional.get() : o);
            }
            return Optional.of(ret);
        }

        @Override
        protected abstract Optional<T> applySingle(Object var1);
    }

    public static abstract class BaseFunction<T>
    implements Function {
        @Override
        public final Optional<Object> apply(Object ... args) {
            if (args.length == 0) {
                return Optional.empty();
            }
            if (args.length == 1) {
                if (args[0] instanceof List) {
                    if (((List)args[0]).isEmpty()) {
                        return Optional.empty();
                    }
                    return this.applyList((List)args[0]);
                }
                if (args[0] instanceof Object[]) {
                    if (((Object[])args[0]).length == 0) {
                        return Optional.empty();
                    }
                    return this.applyList(Arrays.asList((Object[])args[0]));
                }
                if (args[0] == null) {
                    return Optional.empty();
                }
                return this.applySingle(args[0]);
            }
            return this.applyList(Arrays.asList(args));
        }

        protected abstract Optional<Object> applyList(List<Object> var1);

        protected abstract Optional<T> applySingle(Object var1);
    }
}

