/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.spec.BaseSpec;
import com.bazaarvoice.jolt.common.spec.OrderedCompositeSpec;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public enum ExecutionStrategy {
    AVAILABLE_LITERALS{

        @Override
        void processMap(OrderedCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            for (String key : spec.getLiteralChildren().keySet()) {
                if (!inputMap.containsKey(key)) continue;
                Optional<Object> subInputOptional = Optional.of(inputMap.get(key));
                spec.getLiteralChildren().get(key).apply(key, subInputOptional, walkedPath, output, context);
            }
        }

        @Override
        void processList(OrderedCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            Integer originalSize = walkedPath.lastElement().getOrigSize().get();
            for (String key : spec.getLiteralChildren().keySet()) {
                int keyInt = Integer.MAX_VALUE;
                try {
                    keyInt = Integer.parseInt(key);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (keyInt >= inputList.size()) continue;
                Object subInput = inputList.get(keyInt);
                Optional<Object> subInputOptional = subInput == null && originalSize != null && keyInt >= originalSize ? Optional.empty() : Optional.of(subInput);
                spec.getLiteralChildren().get(key).apply(key, subInputOptional, walkedPath, output, context);
            }
        }

        @Override
        void processScalar(OrderedCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            BaseSpec literalChild = spec.getLiteralChildren().get(scalarInput);
            if (literalChild != null) {
                literalChild.apply(scalarInput, Optional.empty(), walkedPath, output, context);
            }
        }
    }
    ,
    ALL_LITERALS{

        @Override
        void processMap(OrderedCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            for (String key : spec.getLiteralChildren().keySet()) {
                Optional<Object> subInputOptional = Optional.empty();
                if (inputMap.containsKey(key)) {
                    subInputOptional = Optional.of(inputMap.get(key));
                }
                spec.getLiteralChildren().get(key).apply(key, subInputOptional, walkedPath, output, context);
            }
        }

        @Override
        void processList(OrderedCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            Integer originalSize = walkedPath.lastElement().getOrigSize().get();
            for (String key : spec.getLiteralChildren().keySet()) {
                Object subInput;
                int keyInt = Integer.MAX_VALUE;
                try {
                    keyInt = Integer.parseInt(key);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Optional<Object> subInputOptional = Optional.empty();
                if (keyInt < inputList.size() && ((subInput = inputList.get(keyInt)) != null || originalSize == null || keyInt < originalSize)) {
                    subInputOptional = Optional.of(subInput);
                }
                spec.getLiteralChildren().get(key).apply(key, subInputOptional, walkedPath, output, context);
            }
        }

        @Override
        void processScalar(OrderedCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            AVAILABLE_LITERALS.processScalar(spec, scalarInput, walkedPath, output, context);
        }
    }
    ,
    COMPUTED{

        @Override
        void processMap(OrderedCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            for (Map.Entry<String, Object> inputEntry : inputMap.entrySet()) {
                ExecutionStrategy.applyKeyToComputed(spec.getComputedChildren(), walkedPath, output, inputEntry.getKey(), Optional.of(inputEntry.getValue()), context);
            }
        }

        @Override
        void processList(OrderedCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            Integer originalSize = walkedPath.lastElement().getOrigSize().get();
            for (int index = 0; index < inputList.size(); ++index) {
                Object subInput = inputList.get(index);
                String subKeyStr = Integer.toString(index);
                Optional<Object> subInputOptional = subInput == null && originalSize != null && index >= originalSize ? Optional.empty() : Optional.of(subInput);
                ExecutionStrategy.applyKeyToComputed(spec.getComputedChildren(), walkedPath, output, subKeyStr, subInputOptional, context);
            }
        }

        @Override
        void processScalar(OrderedCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            ExecutionStrategy.applyKeyToComputed(spec.getComputedChildren(), walkedPath, output, scalarInput, Optional.empty(), context);
        }
    }
    ,
    CONFLICT{

        @Override
        void processMap(OrderedCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            for (Map.Entry<String, Object> inputEntry : inputMap.entrySet()) {
                ExecutionStrategy.applyKeyToLiteralAndComputed(spec, inputEntry.getKey(), Optional.of(inputEntry.getValue()), walkedPath, output, context);
            }
        }

        @Override
        void processList(OrderedCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            Integer originalSize = walkedPath.lastElement().getOrigSize().get();
            for (int index = 0; index < inputList.size(); ++index) {
                Object subInput = inputList.get(index);
                String subKeyStr = Integer.toString(index);
                Optional<Object> subInputOptional = subInput == null && originalSize != null && index >= originalSize ? Optional.empty() : Optional.of(subInput);
                ExecutionStrategy.applyKeyToLiteralAndComputed(spec, subKeyStr, subInputOptional, walkedPath, output, context);
            }
        }

        @Override
        void processScalar(OrderedCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            ExecutionStrategy.applyKeyToLiteralAndComputed(spec, scalarInput, Optional.empty(), walkedPath, output, context);
        }
    }
    ,
    AVAILABLE_LITERALS_WITH_COMPUTED{

        @Override
        void processMap(OrderedCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            AVAILABLE_LITERALS.processMap(spec, inputMap, walkedPath, output, context);
            COMPUTED.processMap(spec, inputMap, walkedPath, output, context);
        }

        @Override
        void processList(OrderedCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            AVAILABLE_LITERALS.processList(spec, inputList, walkedPath, output, context);
            COMPUTED.processList(spec, inputList, walkedPath, output, context);
        }

        @Override
        void processScalar(OrderedCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            AVAILABLE_LITERALS.processScalar(spec, scalarInput, walkedPath, output, context);
            COMPUTED.processScalar(spec, scalarInput, walkedPath, output, context);
        }
    }
    ,
    ALL_LITERALS_WITH_COMPUTED{

        @Override
        void processMap(OrderedCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            ALL_LITERALS.processMap(spec, inputMap, walkedPath, output, context);
            COMPUTED.processMap(spec, inputMap, walkedPath, output, context);
        }

        @Override
        void processList(OrderedCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            ALL_LITERALS.processList(spec, inputList, walkedPath, output, context);
            COMPUTED.processList(spec, inputList, walkedPath, output, context);
        }

        @Override
        void processScalar(OrderedCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
            ALL_LITERALS.processScalar(spec, scalarInput, walkedPath, output, context);
            COMPUTED.processScalar(spec, scalarInput, walkedPath, output, context);
        }
    };


    public void process(OrderedCompositeSpec spec, Optional<Object> inputOptional, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
        Object input = inputOptional.get();
        if (input instanceof Map) {
            this.processMap(spec, (Map)input, walkedPath, output, context);
        } else if (input instanceof List) {
            this.processList(spec, (List)input, walkedPath, output, context);
        } else if (input != null) {
            this.processScalar(spec, input.toString(), walkedPath, output, context);
        }
    }

    abstract void processMap(OrderedCompositeSpec var1, Map<String, Object> var2, WalkedPath var3, Map<String, Object> var4, Map<String, Object> var5);

    abstract void processList(OrderedCompositeSpec var1, List<Object> var2, WalkedPath var3, Map<String, Object> var4, Map<String, Object> var5);

    abstract void processScalar(OrderedCompositeSpec var1, String var2, WalkedPath var3, Map<String, Object> var4, Map<String, Object> var5);

    private static <T extends OrderedCompositeSpec> void applyKeyToLiteralAndComputed(T spec, String subKeyStr, Optional<Object> subInputOptional, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
        BaseSpec literalChild = spec.getLiteralChildren().get(subKeyStr);
        if (literalChild != null) {
            literalChild.apply(subKeyStr, subInputOptional, walkedPath, output, context);
        } else {
            ExecutionStrategy.applyKeyToComputed(spec.getComputedChildren(), walkedPath, output, subKeyStr, subInputOptional, context);
        }
    }

    private static <T extends BaseSpec> void applyKeyToComputed(List<T> computedChildren, WalkedPath walkedPath, Map<String, Object> output, String subKeyStr, Optional<Object> subInputOptional, Map<String, Object> context) {
        BaseSpec computedChild;
        Iterator<T> i$ = computedChildren.iterator();
        while (i$.hasNext() && !(computedChild = (BaseSpec)i$.next()).apply(subKeyStr, subInputOptional, walkedPath, output, context)) {
        }
    }
}

