/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.shiftr.spec;

import com.bazaarvoice.jolt.common.ComputedKeysComparator;
import com.bazaarvoice.jolt.common.ExecutionStrategy;
import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.pathelement.AmpPathElement;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.DollarPathElement;
import com.bazaarvoice.jolt.common.pathelement.HashPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarDoublePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.common.pathelement.TransposePathElement;
import com.bazaarvoice.jolt.common.spec.BaseSpec;
import com.bazaarvoice.jolt.common.spec.OrderedCompositeSpec;
import com.bazaarvoice.jolt.common.spec.SpecBuilder;
import com.bazaarvoice.jolt.common.tree.MatchedElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.shiftr.ShiftrSpecBuilder;
import com.bazaarvoice.jolt.shiftr.spec.ShiftrSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShiftrCompositeSpec
extends ShiftrSpec
implements OrderedCompositeSpec {
    private static final HashMap<Class, Integer> orderMap = new HashMap();
    private static final ComputedKeysComparator computedKeysComparator;
    private static final SpecBuilder<ShiftrSpec> specBuilder;
    private final List<ShiftrSpec> specialChildren;
    private final Map<String, ShiftrSpec> literalChildren;
    private final List<ShiftrSpec> computedChildren;
    private final ExecutionStrategy executionStrategy;

    public ShiftrCompositeSpec(String rawKey, Map<String, Object> spec) {
        super(rawKey);
        ArrayList<ShiftrSpec> special = new ArrayList<ShiftrSpec>();
        LinkedHashMap<String, ShiftrSpec> literals = new LinkedHashMap<String, ShiftrSpec>();
        ArrayList<ShiftrSpec> computed = new ArrayList<ShiftrSpec>();
        if (this.pathElement instanceof AtPathElement) {
            throw new SpecException("@ Shiftr key, can not have children.");
        }
        if (this.pathElement instanceof DollarPathElement) {
            throw new SpecException("$ Shiftr key, can not have children.");
        }
        List<ShiftrSpec> children = specBuilder.createSpec(spec);
        if (children.isEmpty()) {
            throw new SpecException("Shift ShiftrSpec format error : ShiftrSpec line with empty {} as value is not valid.");
        }
        for (ShiftrSpec child : children) {
            if (child.pathElement instanceof LiteralPathElement) {
                literals.put(child.pathElement.getRawKey(), child);
                continue;
            }
            if (child.pathElement instanceof AtPathElement || child.pathElement instanceof HashPathElement || child.pathElement instanceof DollarPathElement || child.pathElement instanceof TransposePathElement) {
                special.add(child);
                continue;
            }
            computed.add(child);
        }
        Collections.sort(computed, computedKeysComparator);
        special.trimToSize();
        computed.trimToSize();
        this.specialChildren = Collections.unmodifiableList(special);
        this.literalChildren = Collections.unmodifiableMap(literals);
        this.computedChildren = Collections.unmodifiableList(computed);
        this.executionStrategy = this.determineExecutionStrategy();
    }

    public Map<String, ShiftrSpec> getLiteralChildren() {
        return this.literalChildren;
    }

    public List<ShiftrSpec> getComputedChildren() {
        return this.computedChildren;
    }

    @Override
    public ExecutionStrategy determineExecutionStrategy() {
        if (this.computedChildren.isEmpty()) {
            return ExecutionStrategy.AVAILABLE_LITERALS;
        }
        if (this.literalChildren.isEmpty()) {
            return ExecutionStrategy.COMPUTED;
        }
        for (BaseSpec baseSpec : this.computedChildren) {
            if (!(baseSpec.getPathElement() instanceof StarPathElement)) {
                return ExecutionStrategy.CONFLICT;
            }
            StarPathElement starPathElement = (StarPathElement)baseSpec.getPathElement();
            for (String literal : this.literalChildren.keySet()) {
                if (!starPathElement.stringMatch(literal)) continue;
                return ExecutionStrategy.CONFLICT;
            }
        }
        return ExecutionStrategy.AVAILABLE_LITERALS_WITH_COMPUTED;
    }

    @Override
    public boolean apply(String inputKey, Optional<Object> inputOptional, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
        MatchedElement thisLevel = this.pathElement.match(inputKey, walkedPath);
        if (thisLevel == null) {
            return false;
        }
        if (this.pathElement instanceof TransposePathElement) {
            TransposePathElement tpe = (TransposePathElement)this.pathElement;
            Optional<Object> optional = tpe.objectEvaluate(walkedPath);
            if (!optional.isPresent()) {
                return false;
            }
            inputOptional = optional;
        }
        walkedPath.add(inputOptional.get(), thisLevel);
        for (ShiftrSpec subSpec : this.specialChildren) {
            subSpec.apply(inputKey, inputOptional, walkedPath, output, context);
        }
        this.executionStrategy.process(this, inputOptional, walkedPath, output, context);
        walkedPath.removeLast();
        walkedPath.lastElement().getMatchedElement().incrementHashCount();
        return true;
    }

    static {
        orderMap.put(AmpPathElement.class, 1);
        orderMap.put(StarRegexPathElement.class, 2);
        orderMap.put(StarDoublePathElement.class, 3);
        orderMap.put(StarSinglePathElement.class, 4);
        orderMap.put(StarAllPathElement.class, 5);
        computedKeysComparator = ComputedKeysComparator.fromOrder(orderMap);
        specBuilder = new ShiftrSpecBuilder();
    }
}

