/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.defaultr;

import com.bazaarvoice.jolt.common.DeepCopy;
import com.bazaarvoice.jolt.defaultr.Key;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class MapKey
extends Key {
    public MapKey(String jsonKey, Object spec) {
        super(jsonKey, spec);
    }

    @Override
    protected int getLiteralIntKey() {
        throw new UnsupportedOperationException("Shouldn't be be asking a MapKey for int getLiteralIntKey().");
    }

    @Override
    protected void applyChild(Object container) {
        if (container instanceof Map) {
            Map defaulteeMap = (Map)container;
            for (String literalKey : this.determineMatchingContainerKeys(defaulteeMap)) {
                this.applyLiteralKeyToContainer(literalKey, defaulteeMap);
            }
        }
    }

    private void applyLiteralKeyToContainer(String literalKey, Map<String, Object> container) {
        Object defaulteeValue = container.get(literalKey);
        if (this.children == null) {
            if (defaulteeValue == null) {
                container.put(literalKey, DeepCopy.simpleDeepCopy(this.literalValue));
            }
        } else {
            if (defaulteeValue == null) {
                defaulteeValue = this.createOutputContainerObject();
                container.put(literalKey, defaulteeValue);
            }
            this.applyChildren(defaulteeValue);
        }
    }

    private Collection<String> determineMatchingContainerKeys(Map<String, Object> container) {
        switch (this.getOp()) {
            case LITERAL: {
                return this.keyStrings;
            }
            case STAR: {
                return container.keySet();
            }
            case OR: {
                HashSet<String> intersection = new HashSet<String>(container.keySet());
                intersection.retainAll(this.keyStrings);
                return intersection;
            }
        }
        throw new IllegalStateException("Someone has added an op type without changing this method.");
    }
}

