/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.chainr;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.chainr.instantiator.ChainrInstantiator;
import com.bazaarvoice.jolt.chainr.instantiator.DefaultChainrInstantiator;
import com.bazaarvoice.jolt.chainr.spec.ChainrEntry;
import com.bazaarvoice.jolt.chainr.spec.ChainrSpec;
import java.util.ArrayList;

public class ChainrBuilder {
    private final Object chainrSpecObj;
    protected ChainrInstantiator chainrInstantiator = new DefaultChainrInstantiator();
    private ClassLoader classLoader = ChainrBuilder.class.getClassLoader();

    public ChainrBuilder(Object chainrSpecObj) {
        this.chainrSpecObj = chainrSpecObj;
    }

    public ChainrBuilder loader(ChainrInstantiator loader) {
        if (loader == null) {
            throw new IllegalArgumentException("ChainrBuilder requires a non-null loader.");
        }
        this.chainrInstantiator = loader;
        return this;
    }

    public ChainrBuilder withClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ChainrBuilder requires a non-null classLoader.");
        }
        this.classLoader = classLoader;
        return this;
    }

    public Chainr build() {
        ChainrSpec chainrSpec = new ChainrSpec(this.chainrSpecObj, this.classLoader);
        ArrayList<JoltTransform> transforms = new ArrayList<JoltTransform>(chainrSpec.getChainrEntries().size());
        for (ChainrEntry entry : chainrSpec.getChainrEntries()) {
            JoltTransform transform = this.chainrInstantiator.hydrateTransform(entry);
            transforms.add(transform);
        }
        return new Chainr(transforms);
    }
}

