/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.ChainrFactory;
import com.bazaarvoice.jolt.JoltCliProcessor;
import com.bazaarvoice.jolt.JoltCliUtilities;
import java.io.File;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public class TransformCliProcessor
implements JoltCliProcessor {
    private static final boolean SUPPRESS_OUTPUT = false;

    @Override
    public void intializeSubCommand(Subparsers subparsers) {
        Subparser transformParser = subparsers.addParser("transform").description("Jolt CLI Transform Tool. This tool will ingest a JSON spec file and an JSON input (from a file or standard input) and run the transforms specified in the spec file on the input. The program will return an exit code of 0 if the input is transformed successfully or a 1 if an error is encountered").defaultHelp(true);
        Object nullFile = null;
        transformParser.addArgument("spec").help("File path to Jolt Transform Spec to execute on the input. This file should contain valid JSON.").type(Arguments.fileType().verifyExists().verifyIsFile().verifyCanRead());
        transformParser.addArgument("input").help("File path to the input JSON for the Jolt Transform operation. This file should contain valid JSON. If this argument is not specified then standard input will be used.").type(Arguments.fileType().verifyExists().verifyIsFile().verifyCanRead()).nargs("?").setDefault((Object)nullFile);
        transformParser.addArgument("-u").help("Turns off pretty print for the output. Output will be raw json with no formatting.").action(Arguments.storeTrue());
    }

    @Override
    public boolean process(Namespace ns) {
        Object output;
        Chainr chainr;
        try {
            chainr = ChainrFactory.fromFile((File)ns.get("spec"));
        }
        catch (Exception e) {
            JoltCliUtilities.printToStandardOut("Chainr failed to load spec file.", false);
            e.printStackTrace(System.out);
            return false;
        }
        File file = (File)ns.get("input");
        Object input = JoltCliUtilities.readJsonInput(file, false);
        try {
            output = chainr.transform(input);
        }
        catch (Exception e) {
            JoltCliUtilities.printToStandardOut("Chainr failed to run spec file.", false);
            return false;
        }
        Boolean uglyPrint = ns.getBoolean("u");
        return JoltCliUtilities.printJsonObject(output, uglyPrint, false);
    }
}

