/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.DiffyCliProcessor;
import com.bazaarvoice.jolt.JoltCliProcessor;
import com.bazaarvoice.jolt.SortCliProcessor;
import com.bazaarvoice.jolt.TransformCliProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;

public class JoltCli {
    private static final Map<String, JoltCliProcessor> JOLT_CLI_PROCESSOR_MAP;

    public static void main(String[] args) {
        System.exit(JoltCli.runJolt(args) ? 0 : 1);
    }

    protected static boolean runJolt(String[] args) {
        Namespace ns;
        ArgumentParser parser = ArgumentParsers.newArgumentParser("jolt");
        Subparsers subparsers = parser.addSubparsers().help("transform: given a Jolt transform spec, runs the specified transforms on the input data.\ndiffy: diff two JSON documents.\nsort: sort a JSON document alphabetically for human readability.");
        for (Map.Entry<String, JoltCliProcessor> entry : JOLT_CLI_PROCESSOR_MAP.entrySet()) {
            entry.getValue().intializeSubCommand(subparsers);
        }
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return false;
        }
        JoltCliProcessor joltToolProcessor = JOLT_CLI_PROCESSOR_MAP.get(args[0]);
        if (joltToolProcessor != null) {
            return joltToolProcessor.process(ns);
        }
        return false;
    }

    static {
        HashMap<String, JoltCliProcessor> temp = new HashMap<String, JoltCliProcessor>();
        temp.put("diffy", new DiffyCliProcessor());
        temp.put("sort", new SortCliProcessor());
        temp.put("transform", new TransformCliProcessor());
        JOLT_CLI_PROCESSOR_MAP = Collections.unmodifiableMap(temp);
    }
}

