/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.ArrayOrderObliviousDiffy;
import com.bazaarvoice.jolt.Diffy;
import com.bazaarvoice.jolt.JoltCliProcessor;
import com.bazaarvoice.jolt.JoltCliUtilities;
import com.bazaarvoice.jolt.JsonUtils;
import java.io.File;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public class DiffyCliProcessor
implements JoltCliProcessor {
    @Override
    public void intializeSubCommand(Subparsers subparsers) {
        Subparser diffyParser = subparsers.addParser("diffy").description("Jolt CLI Diffy Tool. This tool will ingest two JSON inputs (from files or standard input) and perform the Jolt Diffy operation to detect any differences. The program will return an exit code of 0 if no differences are found or a 1 if a difference is found or an error is encountered.").defaultHelp(true);
        diffyParser.addArgument("filePath1").help("File path to feed to Input #1 for the Diffy operation. This file should contain valid JSON.").type(Arguments.fileType().verifyExists().verifyIsFile().verifyCanRead());
        diffyParser.addArgument("filePath2").help("File path to feed to Input #2 for the Diffy operation. This file should contain valid JSON. If this argument is not specified then standard input will be used.").type(Arguments.fileType().verifyExists().verifyIsFile().verifyCanRead()).nargs("?").setDefault((Object)null);
        diffyParser.addArgument("-s").help("Diffy will suppress output and run silently.").action(Arguments.storeTrue());
        diffyParser.addArgument("-a").help("Diffy will not consider array order when detecting differences").action(Arguments.storeTrue());
    }

    @Override
    public boolean process(Namespace ns) {
        boolean suppressOutput = ns.getBoolean("s");
        Object jsonObject1 = JoltCliUtilities.createJsonObjectFromFile((File)ns.get("filePath1"), suppressOutput);
        File file = (File)ns.get("filePath2");
        Object jsonObject2 = JoltCliUtilities.readJsonInput(file, suppressOutput);
        Diffy diffy = ns.getBoolean("a") != false ? new ArrayOrderObliviousDiffy() : new Diffy();
        Diffy.Result result = diffy.diff(jsonObject1, jsonObject2);
        if (result.isEmpty()) {
            JoltCliUtilities.printToStandardOut("Diffy found no differences", suppressOutput);
            return true;
        }
        try {
            JoltCliUtilities.printToStandardOut("Differences found. Input #1 contained this:\n" + JsonUtils.toPrettyJsonString(result.expected) + "\nInput #2 contained this:\n" + JsonUtils.toPrettyJsonString(result.actual), suppressOutput);
        }
        catch (Exception e) {
            JoltCliUtilities.printToStandardOut("Differences found, but diffy encountered an error while writing the result.", suppressOutput);
        }
        return false;
    }
}

