/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.JsonUtils;
import com.bazaarvoice.jolt.chainr.instantiator.ChainrInstantiator;
import java.io.File;
import java.io.FileInputStream;

public class ChainrFactory {
    public static Chainr fromClassPath(String chainrSpecClassPath) {
        return ChainrFactory.fromClassPath(chainrSpecClassPath, null);
    }

    public static Chainr fromClassPath(String chainrSpecClassPath, ChainrInstantiator chainrInstantiator) {
        Object chainrSpec = JsonUtils.classpathToObject(chainrSpecClassPath);
        return ChainrFactory.getChainr(chainrInstantiator, chainrSpec);
    }

    public static Chainr fromFileSystem(String chainrSpecFilePath) {
        return ChainrFactory.fromFileSystem(chainrSpecFilePath, null);
    }

    public static Chainr fromFileSystem(String chainrSpecFilePath, ChainrInstantiator chainrInstantiator) {
        Object chainrSpec = JsonUtils.filepathToObject(chainrSpecFilePath);
        return ChainrFactory.getChainr(chainrInstantiator, chainrSpec);
    }

    public static Chainr fromFile(File chainrSpecFile) {
        return ChainrFactory.fromFile(chainrSpecFile, null);
    }

    public static Chainr fromFile(File chainrSpecFile, ChainrInstantiator chainrInstantiator) {
        Object chainrSpec;
        try {
            FileInputStream fileInputStream = new FileInputStream(chainrSpecFile);
            chainrSpec = JsonUtils.jsonToObject(fileInputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load chainr spec file " + chainrSpecFile.getAbsolutePath());
        }
        return ChainrFactory.getChainr(chainrInstantiator, chainrSpec);
    }

    private static Chainr getChainr(ChainrInstantiator chainrInstantiator, Object chainrSpec) {
        Chainr chainr = chainrInstantiator == null ? Chainr.fromSpec(chainrSpec) : Chainr.fromSpec(chainrSpec, chainrInstantiator);
        return chainr;
    }
}

