/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.utils;

import com.minlessika.utils.Args;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConsoleArgs
implements Args {
    private final String prefix;
    private final String[] args;

    public ConsoleArgs(String[] args) {
        this("", args);
    }

    public ConsoleArgs(String prefix, String[] args) {
        this.prefix = prefix;
        this.args = args;
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>(0);
        Pattern ptn = Pattern.compile(String.format("%s([a-z\\-]+)(=.+)?", this.prefix));
        for (String arg : this.args) {
            Matcher matcher = ptn.matcher(arg);
            if (!matcher.matches()) continue;
            String value = matcher.group(2);
            if (value == null) {
                map.put(matcher.group(1), "");
                continue;
            }
            map.put(matcher.group(1), value.substring(1));
        }
        return map;
    }
}

