/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.tk;

import com.minlessika.rs.RsReplaceHeader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.tk.TkWrap;

public final class TkWithCookieDomain
extends TkWrap {
    private static final Pattern PTN = Pattern.compile("set-cookie: (.+)", 2);
    private static final Pattern DOMAIN_ATTR = Pattern.compile("domain=(.+);", 2);

    public TkWithCookieDomain(final Take take, final CharSequence domain) {
        super(new Take(){

            public Response act(Request req) throws Exception {
                return TkWithCookieDomain.changeDomain(take.act(req), domain);
            }
        });
    }

    private static Response changeDomain(Response res, CharSequence domain) throws IOException {
        Object out = res;
        Iterable headers = res.head();
        for (String header : headers) {
            Matcher matcher = PTN.matcher(header);
            if (!matcher.matches()) continue;
            String cookie = matcher.group(1);
            Matcher domainMatcher = DOMAIN_ATTR.matcher(cookie);
            String domainAttr = String.format("Domain=%s;", domain);
            cookie = domainMatcher.matches() ? domainMatcher.replaceAll(domainAttr) : cookie + domainAttr;
            out = new RsReplaceHeader((Response)out, header, String.format("Set-Cookie: %s", cookie));
        }
        return out;
    }
}

