/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.tk;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.codec.digest.DigestUtils;
import org.takes.Response;
import org.takes.Take;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqHref;
import org.takes.rs.RsPrint;
import org.takes.rs.RsWithHeaders;
import org.takes.rs.RsWithStatus;
import org.takes.tk.TkWrap;

public final class TkCachedFiles
extends TkWrap {
    public TkCachedFiles(Take origin, int maxage, String ... extensions) {
        super(req -> {
            Object resp;
            String location = new RqHref.Smart(req).href().path();
            if (Arrays.stream(extensions).anyMatch(ext -> location.toLowerCase(Locale.ENGLISH).endsWith(String.format(".%s", ext.toLowerCase(Locale.ENGLISH))))) {
                Response raw = origin.act(req);
                String content = new RsPrint(raw).printBody();
                String etag = DigestUtils.md5Hex((String)content).toUpperCase();
                Iterator ifnonematch = new RqHeaders.Base(req).header((CharSequence)"If-None-Match").iterator();
                resp = ifnonematch.hasNext() && ((String)ifnonematch.next()).equals(etag) ? new RsWithStatus(304) : new RsWithHeaders(origin.act(req), new CharSequence[]{String.format("Cache-Control: public, max-age=%s", maxage), String.format("ETag: %s", etag)});
            } else {
                resp = origin.act(req);
            }
            return resp;
        });
    }
}

