/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.utils;

import java.io.IOException;
import java.util.Iterator;
import org.takes.Request;
import org.takes.rq.RqHeaders;

public final class BaseUri {
    private final Request req;
    private final int port;

    public BaseUri(Request req) {
        this(req, 0);
    }

    public BaseUri(Request req, int port) {
        this.req = req;
        this.port = port;
    }

    public String toString() {
        try {
            Iterator hosts = new RqHeaders.Base(this.req).header((CharSequence)"host").iterator();
            Iterator protos = new RqHeaders.Base(this.req).header((CharSequence)"x-forwarded-proto").iterator();
            String host = hosts.hasNext() ? ((String)hosts.next()).trim() : "localhost";
            String proto = protos.hasNext() ? ((String)protos.next()).trim() : "http";
            if (host.contains("localhost") && this.port > 0) {
                return String.format("%s://localhost:%d", proto, this.port);
            }
            return String.format("%s://%s", proto, host);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

