/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.tk;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqHref;
import org.takes.rs.RsWithHeaders;
import org.takes.rs.RsWithStatus;

public final class TkCachedFiles
implements Take {
    private final Take origin;
    private final int maxage;
    private final String[] extensions;

    public TkCachedFiles(Take origin, String ... extension) {
        this(origin, 60, extension);
    }

    public TkCachedFiles(Take origin, int maxage, String ... extensions) {
        this.origin = origin;
        this.maxage = maxage;
        this.extensions = extensions;
    }

    public Response act(Request req) throws Exception {
        Response res;
        block5: {
            RqHref.Smart rqhref = new RqHref.Smart(req);
            String location = rqhref.href().path();
            if (Arrays.stream(this.extensions).anyMatch(ext -> location.endsWith(String.format(".%s", ext)))) {
                try {
                    InputStream input = this.getClass().getResourceAsStream(location);
                    String content = IOUtils.toString((InputStream)input, (String)"UTF-8");
                    String etag = DigestUtils.md5Hex((String)content).toUpperCase();
                    Iterator ifnonematch = new RqHeaders.Base(req).header((CharSequence)"If-None-Match").iterator();
                    if (ifnonematch.hasNext() && ((String)ifnonematch.next()).equals(etag)) {
                        res = new RsWithStatus(304);
                        break block5;
                    }
                    res = new RsWithHeaders(this.origin.act(req), new CharSequence[]{String.format("Cache-Control: public, max-age=%s", this.maxage), String.format("ETag: %s", etag)});
                }
                catch (Exception ex) {
                    res = this.origin.act(req);
                }
            } else {
                res = this.origin.act(req);
            }
        }
        return res;
    }
}

