/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.rs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.takes.Response;
import org.takes.rs.RsEmpty;
import org.takes.rs.RsWrap;

public final class RsReplaceHeader
extends RsWrap {
    private static final Pattern HEADER = Pattern.compile("[a-zA-Z0-9\\-]+:\\p{Print}+");

    public RsReplaceHeader(CharSequence header, CharSequence replacement) {
        this((Response)new RsEmpty(), header, replacement);
    }

    public RsReplaceHeader(final Response res, final CharSequence header, final CharSequence replacement) {
        super(new Response(){

            public Iterable<String> head() throws IOException {
                return RsReplaceHeader.replace(res.head(), header.toString(), replacement.toString());
            }

            public InputStream body() throws IOException {
                return res.body();
            }
        });
    }

    private static Iterable<String> replace(Iterable<String> head, String header, String replacement) {
        if (!HEADER.matcher(replacement).matches()) {
            throw new IllegalArgumentException(String.format("replacement header \"%s\" doesn't match \"%s\" regular expression, but it should, according to RFC 7230", replacement, HEADER));
        }
        ArrayList<String> updatedHead = new ArrayList<String>();
        for (String myHeader : head) {
            if (myHeader.equals(header)) {
                updatedHead.add(replacement);
                continue;
            }
            updatedHead.add(myHeader);
        }
        return updatedHead;
    }
}

