/*
 * Decompiled with CFR 0.152.
 */
package com.minlessika.db;

import com.minlessika.db.Database;
import com.minlessika.db.WrapDatabase;
import com.minlessika.exceptions.DatabaseException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.logging.Logger;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public final class DatabaseLiquibaseUpdate
extends WrapDatabase
implements Database {
    private final String changeLogRelativePath;

    public DatabaseLiquibaseUpdate(Database origin, String changeLogRelativePath) {
        super(origin);
        this.changeLogRelativePath = changeLogRelativePath;
    }

    @Override
    public void start() {
        try (Connection connection = this.getConnection();){
            try (Statement smt2 = connection.createStatement();){
                smt2.execute("UPDATE DATABASECHANGELOGLOCK SET LOCKED=false, LOCKGRANTED=null, LOCKEDBY=null where ID=1");
            }
            catch (SQLException smt2) {
                // empty catch block
            }
            liquibase.database.Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            Liquibase liquibase = new Liquibase(this.changeLogRelativePath, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update("");
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        super.start();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.origin.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.origin.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.origin.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.origin.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.origin.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.origin.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.origin.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.origin.getConnection(username, password);
    }
}

