package com.batch.android.di.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.compat.LocalBroadcastManager;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class LocalBroadcastManagerProvider {
  @NonNull
  public static final LocalBroadcastManager get(Context context) {
    LocalBroadcastManager instance = DI.getInstance().getSingletonInstance(LocalBroadcastManager.class);
    if (instance != null) {
      return instance;
    }
    instance = new LocalBroadcastManager(context);
    DI.getInstance().addSingletonInstance(LocalBroadcastManager.class, instance);
    return instance;
  }

  @Nullable
  public static final LocalBroadcastManager getSingleton() {
    return DI.getInstance().getSingletonInstance(LocalBroadcastManager.class);
  }
}
