package com.batch.android.di.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import com.batch.android.inbox.InboxFetcherInternal;
import java.lang.String;

/**
 * isSingleton = false
 */
public final class InboxFetcherInternalProvider {
  @NonNull
  public static final InboxFetcherInternal get(@NonNull Context context, String installID) {
    return InboxFetcherInternal.provide(context, installID);
  }

  @NonNull
  public static final InboxFetcherInternal get(@NonNull Context context, String installID,
      boolean useCache) {
    return InboxFetcherInternal.provide(context, installID, useCache);
  }

  @NonNull
  public static final InboxFetcherInternal get(@NonNull Context context,
      @NonNull String userIdentifier, @NonNull String authenticationKey) {
    return InboxFetcherInternal.provide(context, userIdentifier, authenticationKey);
  }

  @NonNull
  public static final InboxFetcherInternal get(@NonNull Context context,
      @NonNull String userIdentifier, @NonNull String authenticationKey, boolean useCache) {
    return InboxFetcherInternal.provide(context, userIdentifier, authenticationKey, useCache);
  }
}
