package com.batch.android.di.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.core.KVUserPreferencesStorage;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class KVUserPreferencesStorageProvider {
  @NonNull
  public static final KVUserPreferencesStorage get(Context context) {
    KVUserPreferencesStorage instance = DI.getInstance().getSingletonInstance(KVUserPreferencesStorage.class);
    if (instance != null) {
      return instance;
    }
    instance = new KVUserPreferencesStorage(context);
    DI.getInstance().addSingletonInstance(KVUserPreferencesStorage.class, instance);
    return instance;
  }

  @Nullable
  public static final KVUserPreferencesStorage getSingleton() {
    return DI.getInstance().getSingletonInstance(KVUserPreferencesStorage.class);
  }
}
